/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.widgets.grapher.highlighters;

import org.eclipse.hyades.ui.widgets.grapher.Graph;
import org.eclipse.hyades.ui.widgets.grapher.GraphHighlighter;

/**
 * The ThicknessHighlighter is a graph highlighter implementation. When a graph
 * is highlighted, the line width is increased. When the graph is unhighlighted
 * the linewidth is reduced.
 * 
 * @author gchristelis
 * @since 4.0.0
 *
 */
public class ThicknessHighlighter implements GraphHighlighter 
{
    private int thickness;	
    private int new_thickness = 6;

    /**
     * ThicknessHighlighter constructor assumes a highlighted thinkness of 6
     */
	public ThicknessHighlighter() 
    {
	}

    /**
     * ThicknessHighlighter constructor
     * @param highlighted_thickness the highlight graph thickness to use
     */
	public ThicknessHighlighter(int highlighted_thickness) 
    {
		this.new_thickness = highlighted_thickness;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.GraphHighlighter#setHighlight(org.eclipse.hyades.ui.widgets.grapher.Graph)
	 */
	public void setHighlight(Graph g) 
    {
		thickness = g.getLineWidth();
		if (thickness >= new_thickness) 
        {
			g.setLineWidth(new_thickness+4);
		} 
        else 
        {
			g.setLineWidth(new_thickness);
		}
	}
    
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.ui.widgets.grapher.GraphHighlighter#unsetHighlight(org.eclipse.hyades.ui.widgets.grapher.Graph)
	 */
	public void unsetHighlight(Graph g) 
    {
		g.setLineWidth(thickness);
	}		
}