/**********************************************************************
 * Copyright (c) 2005, 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.ui.widgets.zoomslider;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class TestZoomSlider implements KeyListener
{
	static ZoomSlider slider;
	static ZoomSlider slider2;	
	
	public void keyPressed(KeyEvent e) 
	{
		slider.setMinimized(!slider.isMinimized());
		slider.redraw();
		slider.getParent().layout(true);
		slider2.setMinimized(!slider2.isMinimized());
		slider2.redraw();
		slider2.getParent().layout(true);
	}

	public void keyReleased(KeyEvent e) {		
	}
	
	public static void main(String [] args) throws Exception
	{
		Display display = new Display();
		Shell shell = new Shell(display);
		
		shell.setLayout( new FillLayout());

		Composite composite= new Composite(shell, SWT.NONE);
		composite.setLayout(new RowLayout(SWT.VERTICAL));
		
		Label l = new Label(composite, SWT.BORDER);
		l.setText("START");
		slider = new ZoomSlider(composite);
		slider.setOrientation(ZoomSlider.HORIZONTAL);
		slider.setTitle("MINIMIZED");
		
		slider2 = new ZoomSlider(composite);
		slider2.setOrientation(ZoomSlider.VERTICAL);
		slider2.setTitle("MINIMIZED");

		slider.addKeyListener(new TestZoomSlider());
		slider2.addKeyListener(new TestZoomSlider());

		l = new Label(composite, SWT.BORDER);
		l.setText("END");

	    // ------------------------
	    // Your code comes to here.
	    // ------------------------
	    shell.pack();
	    shell.open();
	    while( !shell.isDisposed())
	    {
	      if(!display.readAndDispatch()) 
	      display.sleep();
	    }
	    display.dispose();
	}
}
