/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.widgets.zoomslider;

/**
 * A ZoomControlBarEvent represents a change in a ZoomControlBar.
 * 
 * @author gchristelis
 * @since 4.0.0
 */
public class ZoomControlBarEvent extends org.eclipse.swt.events.TypedEvent
{
	private static final long serialVersionUID = 4050484495612393522L;
    
    /**
     * The new control value
     */
	public double value;
    
    /**
     * A boolean representing the finished state of the control bar change.
     * This value is true if the change is complete. 
     */
    public boolean finished;
    
    /**
     * Construct a new ZoomControlBarEvent
     * @param source the ZoomControlBar source
     * @param value the new value of the control 
     * @param finished the finished status of the control bar change
     */
    public ZoomControlBarEvent(Object source, double value, boolean finished)
    {
        super(source);
        
        this.value = value;
        this.finished = finished;
    }
}
