/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.widgets.zoomslider;

/**
 * The ZoomControlBarListener interface must be implemented by 
 * any listeners requesting to hear of changes to a ZoomControlBar 
 * 
 * @author gchristelis
 * @since 4.0.0
 */
public interface ZoomControlBarListener extends java.util.EventListener
{
    /**
     * A change in a ZoomControlBar has occured.
     * 
     * @param event details regarding the change in the ZoomControlBar
     */
    public void zoomControlBarChanged(ZoomControlBarEvent event);
}
