/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.widgets.zoomslider;

//import java.awt.image.*;
//import java.awt.*;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

/**
 * Extends <code>(blah).slider.Bar</code> to provide a slider bar
 * which displays an iconic image
 */

public class ZoomImageBar extends ZoomControlBar
{
    /*  The iconic image which will be displayed on the bar. This will change
        depending on whether this ImageBar is currently enabled or disabled */
    Image barImage;
    
    // The iconic image for the ImageBar's enabled state
    Image enabledImage;

    // The iconic image for the ImageBar's disabled state
    Image disabledImage;
        
    // Width and height of the iconic image
    int imageWidth, imageHeight; 
        
    /**
     * ZoomImageBar Constructor
     * @param slider the slider on which this ImageBar is to appear
     * @param value the value on the slider at which this ImageBar is to initially appear
     * @param enabledImage the image to to be used as the enabled iconic image
     * @param disabledImage the image is to be used as the disabled iconic image
     * @param size the required size for this ImageBar. Size means height when the
     * ImageBar is on a vertical slider, and width when on a horizontal slider
     */
    public ZoomImageBar(ZoomSlider slider, double value, Image enabledImage, Image disabledImage, int size)
    {
    	super(slider, value);
    	
    	this.size = size;
    	
    	this.enabledImage = enabledImage; 
    	this.disabledImage = disabledImage; 
    	    	
    	barImage = enabledImage;
    	
        imageWidth = barImage.getBounds().width;
        imageHeight = barImage.getBounds().height;
    }
        
    /**
     * Converts the iconic image file references into actual images using a 
     * MediaTracker to ensure that the images are fully loaded before returning
     * from this method.
     * @param enabledImageFile the full path name of the .gif file whose image is to be 
     * used as the enabled iconic image
     * @param disabledImageFile the full path name of the .gif file whose image is to be 
     * used as the disabled iconic image
     */    
/*    
    void trackImages(String enabledImageFile, String disabledImageFile)
    {
    	MediaTracker tracker = new MediaTracker(slider);
                
        enabledImage = this.slider.getToolkit().getImage(getClass().getResource(enabledImageFile));
        disabledImage = this.slider.getToolkit().getImage(getClass().getResource(disabledImageFile));

        tracker.addImage(enabledImage, 0);
        tracker.addImage(disabledImage, 1);
        	    
        try
        {
        	tracker.waitForID(0);
        	tracker.waitForID(1);
        }
        catch (InterruptedException e){}
    }    
*/

    /**
     * Paint this ImageBar
     * @param g the <code>Graphics</code> context on which to paint
     */
    public void paint(GC g)
    {
        area = getDrawingArea(value);
          
        // Create the ZoomControlBar's Image
        if (image == null)
        {
        	// Draw the ZoomControlBar on a temporary Image, and get its ImageData
        	Image tempImage = new Image(slider.getDisplay(), area.width, area.height);
			draw3DBox(new GC(tempImage), 0, 0, area.width, area.height, color);
        	ImageData imageData = tempImage.getImageData();
        	tempImage.dispose();
        	
	        // Set the Alpha blending on the ImageData
	        for (int i = 0; i < area.width; i++)
	        { 
                for (int j = 0; j < area.height; j++) 
                { 
                        imageData.setAlpha(i, j, 180); 
                } 
	        } 

			// Use the ImageData to create the required transparent Image
        	image = new Image(slider.getDisplay(), imageData);
        }
                
		// Draw the ZoomControlBar's Image on the Graphics Context        
        g.drawImage(image, area.x, area.y);
            
        // Draw the iconic image on top
        try
        {
            g.drawImage(barImage, area.x + area.width/2 - imageWidth/2, area.y + area.height/2 - imageHeight/2); 
        }
        catch (NullPointerException e){}
    }
        
    /**
     * Performs the color filtering necessary to make this ImageBar transparent
     */
/*    private final class MyColorFilter extends RGBImageFilter 
    { 
        public int filterRGB(int x, int y, int rgb) 
        { 
            return rgb & 0x80ffffff; 
        } 
    }
  */  
    /**
     * Enable/disable this ImageBar
     * @param b set true to enable, false to disable
     */
    public void setEnabled(boolean b)
    {
        super.setEnabled(b);
        
        if (b)
        {
           	barImage = enabledImage;
        }
        else
        {
            barImage = disabledImage;
        }    

        imageWidth = barImage.getBounds().width;
        imageHeight = barImage.getBounds().height;
        
        this.slider.updateScale();
    }
}    
