/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.widgets.zoomslider;

/**
 * An event describing the change in the state of a zoom slider. Change occurs when
 * the zoom slider is zoomed or transposed.
 * @author gchristelis
 * @since 4.0.0
 */
public class ZoomSliderEvent extends org.eclipse.swt.events.TypedEvent
{
	private static final long serialVersionUID = 3832622872127944245L;
    
    /**
     * The ZOOMED event constant is used to identify a zoom event in the slider
     */
	public static int ZOOMED = 0;
    
    /**
     * The TRANSPOSED event constant is used to identify a transpose event in the slider
     */    
    public static int TRANSPOSED = 1;
    
    /**
     *  A constant int defining the nature of the zoomslider change. Possible values are 
     *  <li>ZOOMED</li>
     *  <li>TRANSPOSED</li>
     */
    public int action;
    
    /**
     * A boolean symbolising the state of the change. If finished is true, then the current zoom or transpose is complete.
     */
    public boolean finished;
    
    /**
     * Generate a new zool slider change event
     * @param source the source slider of the event
     * @param action the type of action (ZoomSliderEvent.ZOOMED or ZoomSliderEvent.TRANSPOSED)
     * @param finished true if the change is complete
     */
    public ZoomSliderEvent(Object source, int action, boolean finished)
    {
        super(source);
        
        this.action = action;
        this.finished = finished;
    }
}
