/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.widgets.zoomslider;

/**
 * The zoom slider listener notifies the receiver of a change in the
 * status of a particular zoom slider.
 * 
 * @author gchristelis
 * @since 4.0.0
 */
public interface ZoomSliderListener extends java.util.EventListener 
{
    /**
     * A change in the zoom slider has occured. Changes can be of a 
     * zoom or transpose type, as defined in the ZoomSliderEvent.
     * @param event the ZoomSliderEvent associated with this change
     * @see org.eclipse.hyades.ui.widgets.zoomslider.ZoomSliderEvent
     */
    public void zoomSliderChanged(ZoomSliderEvent event);
}
