/**********************************************************************
 * Copyright (c) 2005, 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.widgets.zoomslider;

import java.math.BigDecimal;

import com.ibm.icu.text.DecimalFormat;

/**
 * A general utilities class for zoom slider functionality
 * 
 * @author gchristelis
 *
 */
public class ZoomSliderUtilities
{
    /**
     * Calculate the order of magnitude of a double
     * @param number the double to calculate the magnitude of
     * @return the order of magnitude as an int
     */
    public static int calculateOOM(double number)
    {
        int oom = 0;
        double old;
        
        if (number == 0.0) 
        {
            return 1;
        }

        while (number >= 10)
        {
            oom++;
            old = number;
            number = number / 10;
            if (old == number) 
                break;
        }

        while (number < 1)
        {
            oom--;
            old = number;
            number= number* 10;
            if (old == number) 
                break;
        }

        return oom;
    }

    /**
     * Round to the nearest multiple of rounder 
     * @param roundee
     * @param rounder
     * @return the rounded value
     */
    public static double round(double roundee, double rounder)
    {
        BigDecimal biggy = new BigDecimal(roundee/rounder);
        
        biggy = biggy.setScale(0, BigDecimal.ROUND_HALF_UP);
        
        biggy = biggy.multiply(new BigDecimal(rounder));
        
        int scale = 0;
        
        if (rounder < 1) 
            scale = Math.abs(calculateOOM(rounder));
        
        biggy = biggy.setScale(scale, BigDecimal.ROUND_HALF_UP);
        
        return biggy.doubleValue();
    }
    

    /**
     * Convert a double value to a string representation
     * @param n the double value
     * @return a string representation of the double value
     */    
    public static String double2String(double n)
    {        
        // TVT Bug 106080
        DecimalFormat nf = (DecimalFormat) DecimalFormat.getNumberInstance();                
        return nf.format(n);                        
    }
}	
