/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BaseDetails.java,v 1.2 2008/12/08 13:32:07 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit.editor.internal.presentation;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
/**
 * @author slavescu
 */
public abstract class BaseDetails extends Composite implements IDetails {
	protected Control currentControl;
	private FocusListener focusListener;
	/**
	 * @param parent
	 * @param style
	 */
	public BaseDetails(Composite parent, int style) {
		super(parent, style);
	}
	public Control getFocusTo() {
		return currentControl;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.swt.widgets.Control#addFocusListener(org.eclipse.swt.events.FocusListener)
	 */
	public void addFocusListenerTo(Control control) {
		if (focusListener == null) {
			focusListener = new FocusListener() {
				/*
				 * (non-Javadoc)
				 * 
				 * @see org.eclipse.swt.events.FocusListener#focusLost(org.eclipse.swt.events.FocusEvent)
				 */
				public void focusLost(FocusEvent e) {
					if (e.getSource() instanceof Control)
						currentControl = (Control) e.getSource();
				}
				/*
				 * (non-Javadoc)
				 * 
				 * @see org.eclipse.swt.events.FocusListener#focusGained(org.eclipse.swt.events.FocusEvent)
				 */
				public void focusGained(FocusEvent e) {
					if (e.getSource() instanceof Control)
						currentControl = (Control) e.getSource();
				}
			};
		}
		control.addFocusListener(focusListener);
	}
	
	public Control getFocusTo(Object object) {
		return null;
	}
}