/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ControlKeyDetails.java,v 1.3 2008/05/29 21:14:11 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit.editor.internal.presentation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.hyades.models.internal.probekit.ControlKey;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.models.internal.probekit.impl.ControlKeyImpl;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.provider.ControlKeyItemProvider;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ControlKeyDetails extends BaseDetails implements ModifyListener {
	protected final EAttribute NAME = ProbekitPackage.eINSTANCE.getControlKey_Name();
	protected final EAttribute VALUE = ProbekitPackage.eINSTANCE.getControlKey_Value();
	protected Text name;
	protected Text value;
	protected boolean isDisplaying;
	protected ControlKey currentSelection;
	protected ControlKeyItemProvider itemProvider;
	protected ProbekitItemProviderAdapterFactory itemFactory;
	public ControlKeyDetails(ProbekitWidgetFactory factory, ProbekitItemProviderAdapterFactory itemFactory, Composite composite, int style) {
		super(composite, style);
		this.itemFactory = itemFactory;
		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 1;
		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
		factory.createLabel(this, ProbekitMessages._12, SWT.NONE);
		name = factory.createText(this, "", SWT.NULL);
		name.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		// name.setData(new Integer(0));
		factory.createLabel(this, ProbekitMessages._13, SWT.NONE);
		value = factory.createText(this, "", SWT.NONE);
		value.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		// value.setData(new Integer(0));
		// add listeners - don't change the order in which the listeners are
		// added
		// because of team support issues modify listeners should always be the
		// last one added
		name.addModifyListener(this);
		value.addModifyListener(this);
		itemProvider = (ControlKeyItemProvider) itemFactory.createControlKeyAdapter();
		
		addFocusListenerTo(name);
		addFocusListenerTo(value);
	}
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(Object object) {
		if (name.isFocusControl() || value.isFocusControl())
			return;
		currentSelection = (ControlKey) object;
		isDisplaying = true;
		name.setText(currentSelection.getName() == null ? "" : currentSelection.getName());
		value.setText(currentSelection.getValue() == null ? "" : currentSelection.getValue());
		isDisplaying = false;
	}
	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(Object currentSelection) {
		this.currentSelection = (ControlKey) currentSelection;
		this.currentSelection.setName(name.getText().trim());
		this.currentSelection.setValue(value.getText().trim());
		return false;
	}
	public void setFocusToText() {
		name.setFocus();
		name.selectAll();
	}
	/**
	 * Sent when the text is modified.
	 * 
	 * @param e
	 *            an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e) {
		if (currentSelection == null)
			return;
		if (e.getSource() == name) {
			String text = name.getText().trim();
			if (!text.equals(currentSelection.getName())) {
				if (text.length() == 0 && currentSelection.getName() == null)
					return;
				IItemPropertyDescriptor descriptor = itemProvider.getPropertyDescriptor(currentSelection, NAME);
				if (descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);
			}
		} else if (e.getSource() == value) {
			String text = value.getText().trim();
			if (!text.equals(currentSelection.getValue())) {
				if (text.length() == 0 && currentSelection.getValue() == null)
					return;
				IItemPropertyDescriptor descriptor = itemProvider.getPropertyDescriptor(currentSelection, VALUE);
				if (descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);
			}
		}
	}
	public void dispose() {
		itemFactory = null;
		itemProvider = null;
		name = null;
		value = null;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.probekit.internal.presentation.IDetails#isDetailsFor(java.lang.Object)
	 */
	public boolean isDetailsFor(Object object) {
		if (object instanceof ControlKey || object instanceof ControlKeyImpl) {
			return true;
		}
		return false;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.probekit.internal.presentation.IDetails#setFocusTo()
	 */
	public void setFocusTo() {
		setFocusToText();
	}

	public void refresh() {
	}
}