/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ControlNameDetails.java,v 1.3 2008/05/29 21:14:11 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit.editor.internal.presentation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.hyades.models.internal.probekit.ControlName;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.models.internal.probekit.impl.ControlNameImpl;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.provider.ControlNameItemProvider;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ControlNameDetails extends BaseDetails implements ModifyListener {
	protected final EAttribute LANGUAGE = ProbekitPackage.eINSTANCE.getControlName_Lang();
	protected final EAttribute TEXT = ProbekitPackage.eINSTANCE.getControlName_Text();
	protected Text language;
	protected Text name;
	protected boolean isDisplaying;
	protected ControlName currentSelection;
	protected ControlNameItemProvider itemProvider;
	protected ProbekitItemProviderAdapterFactory itemFactory;
	public ControlNameDetails(ProbekitWidgetFactory factory, ProbekitItemProviderAdapterFactory itemFactory, Composite composite, int style) {
		super(composite, style);
		this.itemFactory = itemFactory;
		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 1;
		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
		factory.createLabel(this, ProbekitMessages._14, SWT.NONE);
		language = factory.createText(this, "", SWT.NULL);
		language.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		// language.setData(new Integer(0));
		factory.createLabel(this, ProbekitMessages._15, SWT.NONE);
		name = factory.createText(this, "", SWT.NONE);
		name.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		// name.setData(new Integer(0));
		// add listeners - don't change the order in which the listeners are
		// added
		// because of team support issues modify listeners should always be the
		// last one added
		language.addModifyListener(this);
		name.addModifyListener(this);
		itemProvider = (ControlNameItemProvider) itemFactory.createControlNameAdapter();
		
		addFocusListenerTo(name);
		addFocusListenerTo(language);

	}
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(Object object) {
		if (language.isFocusControl() || name.isFocusControl())
			return;
		currentSelection = (ControlName) object;
		isDisplaying = true;
		language.setText(currentSelection.getLang() == null ? "" : currentSelection.getLang());
		name.setText(currentSelection.getText() == null ? "" : currentSelection.getText());
		isDisplaying = false;
	}
	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(Object currentSelection) {
		this.currentSelection = (ControlName) currentSelection;
		this.currentSelection.setLang(language.getText().trim());
		this.currentSelection.setText(name.getText().trim());
		return false;
	}
	public void setFocusToText() {
		language.setFocus();
		language.selectAll();
	}
	/**
	 * Sent when the text is modified.
	 * 
	 * @param e
	 *            an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e) {
		if (currentSelection == null)
			return;
		if (e.getSource() == language) {
			String text = language.getText().trim();
			if (!text.equals(currentSelection.getLang())) {
				if (text.length() == 0 && currentSelection.getLang() == null)
					return;
				IItemPropertyDescriptor descriptor = itemProvider.getPropertyDescriptor(currentSelection, LANGUAGE);
				if (descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);
			}
		} else if (e.getSource() == name) {
			String text = name.getText().trim();
			if (!text.equals(currentSelection.getText())) {
				if (text.length() == 0 && currentSelection.getText() == null)
					return;
				IItemPropertyDescriptor descriptor = itemProvider.getPropertyDescriptor(currentSelection, TEXT);
				if (descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);
			}
		}
	}
	public void dispose() {
		itemFactory = null;
		itemProvider = null;
		language = null;
		name = null;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.probekit.internal.presentation.IDetails#isDetailsFor(java.lang.Object)
	 */
	public boolean isDetailsFor(Object object) {
		if (object instanceof ControlName || object instanceof ControlNameImpl) {
			return true;
		}
		return false;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.probekit.internal.presentation.IDetails#setFocusTo()
	 */
	public void setFocusTo() {
		setFocusToText();
	}

	public void refresh() {
	}
}