/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DescriptionDetails.java,v 1.3 2008/05/29 21:14:11 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit.editor.internal.presentation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.hyades.models.internal.probekit.Description;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.models.internal.probekit.impl.DescriptionImpl;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.provider.DescriptionItemProvider;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class DescriptionDetails extends BaseDetails implements ModifyListener {
	protected final EAttribute LANGUAGE = ProbekitPackage.eINSTANCE.getDescription_Lang();
	protected final EAttribute DESCRIPTION = ProbekitPackage.eINSTANCE.getDescription_Value();
	protected Text language;
	protected Text description;
	protected boolean isDisplaying;
	protected Description currentSelection;
	protected DescriptionItemProvider itemProvider;
	protected ProbekitItemProviderAdapterFactory itemFactory;
	public DescriptionDetails(ProbekitWidgetFactory factory, ProbekitItemProviderAdapterFactory itemFactory, Composite composite, int style) {
		super(composite, style);
		this.itemFactory = itemFactory;
		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 1;
		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
		factory.createLabel(this, ProbekitMessages._14, SWT.NONE);
		language = factory.createText(this, "", SWT.NULL);
		language.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		language.setData(new Integer(0));
		factory.createLabel(this, ProbekitMessages._17, SWT.NONE);
		description = factory.createText(this, "", ProbekitWidgetFactory.BORDER_STYLE | SWT.V_SCROLL | SWT.H_SCROLL | SWT.MULTI | SWT.WRAP);
		GridData descLayout = new GridData(GridData.FILL_BOTH);
		description.setLayoutData(descLayout);
		description.setData(new Integer(3));
		// add listeners - don't change the order in which the listeners are
		// added
		// because of team support issues modify listeners should always be the
		// last one added
		language.addModifyListener(this);
		description.addModifyListener(this);
		itemProvider = (DescriptionItemProvider) itemFactory.createDescriptionAdapter();
		
		addFocusListenerTo(language);
		addFocusListenerTo(description);
	}
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(Object object) {
		if (language.isFocusControl() || description.isFocusControl())
			return;
		currentSelection = (Description) object;
		isDisplaying = true;
		language.setText(currentSelection.getLang() == null ? "" : currentSelection.getLang());
		description.setText(currentSelection.getValue() == null ? "" : currentSelection.getValue());
		isDisplaying = false;
	}
	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(Object currentSelection) {
		this.currentSelection = (Description) currentSelection;
		this.currentSelection.setLang(language.getText().trim());
		this.currentSelection.setValue(description.getText());
		return false;
	}
	public void setFocusToText() {
		language.setFocus();
		language.selectAll();
	}
	/**
	 * Sent when the text is modified.
	 * 
	 * @param e
	 *            an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e) {
		if (currentSelection == null)
			return;
		if (e.getSource() == language) {
			String text = language.getText().trim();
			if (!text.equals(currentSelection.getLang())) {
				if (text.length() == 0 && currentSelection.getLang() == null)
					return;
				IItemPropertyDescriptor descriptor = itemProvider.getPropertyDescriptor(currentSelection, LANGUAGE);
				if (descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);
			}
		} else if (e.getSource() == description) {
			String text = description.getText();
			if (!text.equals(currentSelection.getValue())) {
				if (text.length() == 0 && currentSelection.getValue() == null)
					return;
				IItemPropertyDescriptor descriptor = itemProvider.getPropertyDescriptor(currentSelection, DESCRIPTION);
				if (descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);
			}
		}
	}
	public void dispose() {
		itemFactory = null;
		itemProvider = null;
		description = null;
		language = null;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.probekit.internal.presentation.IDetails#isDetailsFor(java.lang.Object)
	 */
	public boolean isDetailsFor(Object object) {
		if (object instanceof Description || object instanceof DescriptionImpl) {
			return true;
		}
		return false;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.probekit.internal.presentation.IDetails#setFocusTo()
	 */
	public void setFocusTo() {
		setFocusToText();
	}

	public void refresh() {
	}
}