/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DetailsContent.java,v 1.2 2008/12/08 13:32:07 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit.editor.internal.presentation;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class DetailsContent extends Composite {
	protected StackLayout detailsLayout;
	protected ProbekitWidgetFactory widgetFactory;
	protected ProbekitItemProviderAdapterFactory factory;
	protected Composite[] details;
	protected Composite currentDetails;
	
	/**
	 * Constructor for DetailsContent.
	 */
	public DetailsContent(ProbekitWidgetFactory widgetFactory, ProbekitItemProviderAdapterFactory factory, Composite composite, int style) {
		super(composite, style);
		this.widgetFactory = widgetFactory;
		this.factory = factory;
	}
	public void createContent() {
		detailsLayout = new StackLayout();
		this.setLayout(detailsLayout);
		GridData detailsGrid = new GridData(GridData.FILL_BOTH);
		detailsGrid.horizontalIndent = 10;
		this.setLayoutData(detailsGrid);
		List detailsList = new ArrayList();
		detailsList.add(new DescriptionDetails(widgetFactory, factory, this, SWT.NONE));
		//		details[i++] = new CodeDetails(widgetFactory, factory, this,
		// SWT.NONE);
		detailsList.add(new FragmentAtClassScopeDetails(widgetFactory, factory, this, SWT.NONE));
		detailsList.add(new NameDetails(widgetFactory, factory, this, SWT.NONE));
		detailsList.add(new ControlNameDetails(widgetFactory, factory, this, SWT.NONE));
		detailsList.add(new ControlKeyDetails(widgetFactory, factory, this, SWT.NONE));
		detailsList.add(new AllImportsDetails(widgetFactory, factory, this, SWT.NONE));
		detailsList.add(new InvocationObjectDetails(widgetFactory, factory, this, SWT.NONE));
		detailsList.add(new AllTargetsDetails(widgetFactory, factory, this, SWT.NONE));
		detailsList.add(new FragmentDetails(widgetFactory, factory, this, SWT.NONE));
		detailsList.add(new StaticFieldDetails(widgetFactory, factory, this, SWT.NONE));
		details = new Composite[detailsList.size()];
		details = (Composite[]) detailsList.toArray(details);
		hideDetails();
	}
	
	public void showDetailsFor(Object data) {
		Composite detail = getDetailsFor(data);
		if (detail != null) {
			setCurrentDetails(detail);
			showDetail(detail, data);
			setFocusFor(data);
		} else {
			hideDetails();
		}
	}
	
	public void setFocusFor(Object object) {
		Composite detail = getDetailsFor(object);
		if (detail != null) {
			setCurrentDetails(detail);
			setFocusToControl(detail, object);
		}
	}
	/**
	 * @param detail
	 */
	private void setFocusToControl(Composite detail, Object object) {
		Control  cc = ((IDetails)detail).getFocusTo(object); 
		if (cc == null || cc.isDisposed()) {
			cc = ((IDetails)detail).getFocusTo(); 
		}
		setFocusToControl(cc);
	}
	private void setFocusToControl(Control cc) {
		if (cc != null && !cc.isDisposed()) {
			if (cc instanceof Text) {
				Text tt = (Text) cc;
				tt.setFocus();
				tt.selectAll();
			} else
				cc.setFocus();
		}
	}
	private void hideDetails() {
		for (int i = 0; i < details.length; i++) {
			details[i].setVisible(false);
		}
		// descriptionDetails.setVisible(false);
		// codeDetails.setVisible(false);
	}
	private Composite getDetailsFor(Object object) {
		for (int i = 0; i < details.length; i++) {
			if (((IDetails) details[i]).isDetailsFor(object)) {
				return (details[i]);
			}
		}
		return null;
	}
	
	private void showDetail(Composite detail, Object data) {
		IDetails currentDetails = (IDetails)detail;
		currentDetails.display(data);
		detailsLayout.topControl = detail;
		layout();
	}
	
	
	public void dispose() {
		factory = null;
		widgetFactory = null;
		for (int i = 0; i < details.length; i++) {
			details[i].dispose();
		}
	}
	
	private void setCurrentDetails(Composite details) {
		this.currentDetails = details;
	}
	
	private Composite getCurrentDetails() {
		return currentDetails;
	}
	
	public void refresh() {
		if (getCurrentDetails() != null)
			((IDetails)getCurrentDetails()).refresh();
	}
}