/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EObjectListAdapterFactory.java,v 1.1 2005/06/07 04:04:15 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.hyades.probekit.editor.internal.presentation;

import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;


public class EObjectListAdapterFactory extends ComposedAdapterFactory {
	public EObjectListAdapterFactory(List list) {
		super(list);
	}

	public Object adapt(Object target, Object type) {
		Object adapter = super.adapt(target, type);
		if(adapter == null) {
			if(target instanceof EObjectContainmentEList) {
				adapter = adapt((EObjectContainmentEList)target, type);
			}
		}
		return adapter;
	}
	
	public Object adapt(EObjectContainmentEList target, Object type) {
		Iterator iterator = adapterFactories.iterator();
		while(iterator.hasNext()) {
			AdapterFactory factory = (AdapterFactory)iterator.next();
			if(factory.isFactoryForType(type)) {
				Object result = factory.adapt(target, type);
				if(result != null) {
					return result;
				}
			}
		}
		
		return null;
	}
	
}
