/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EObjectListAdapterFactoryEditingDomain.java,v 1.1 2005/06/07 04:04:15 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.hyades.probekit.editor.internal.presentation;

import java.util.Collection;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitUtil;



public class EObjectListAdapterFactoryEditingDomain extends AdapterFactoryEditingDomain {
	public EObjectListAdapterFactoryEditingDomain(AdapterFactory adapterFactory, CommandStack commandStack) {
		super(adapterFactory, commandStack);
	}

	public Command createCommand(Class commandClass, CommandParameter commandParameter) {
		Collection c = commandParameter.getCollection();
		commandParameter.collection = ProbekitUtil.unwrap(c);
		return super.createCommand(commandClass, commandParameter);
	}
}
