/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FragmentAtClassScopeDetails.java,v 1.4 2008/07/17 14:21:56 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit.editor.internal.presentation;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.hyades.models.internal.probekit.Probe;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.models.internal.probekit.impl.ProbeImpl;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbeItemProvider;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

public class FragmentAtClassScopeDetails extends BaseDetails {
	protected ProbekitItemProviderAdapterFactory itemFactory;
	protected ISourceViewer _methodViewer;
	protected ProbeItemProvider itemProvider;
	protected boolean isDisplaying;
	protected Probe currentSelection;
	protected JavaTextTools _javaTextTools;
	protected JavaSourceViewerConfiguration _methodViewerConfiguration;
	protected ProbekitWidgetFactory widgetFactory;

	public FragmentAtClassScopeDetails(ProbekitWidgetFactory factory, ProbekitItemProviderAdapterFactory itemFactory, Composite composite, int style) {
		super(composite, style);
		this.itemFactory = itemFactory;
		this.widgetFactory = factory;
		itemProvider = (ProbeItemProvider) itemFactory.createProbeAdapter();
		
		Composite page = this;
		createControl(page);
	}
	
	protected void createControl(Composite page) {
		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 1;
		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
		
		createTitle(page);
		createCode(page);
	}

	
	protected void createCode(Composite parent) {
		_javaTextTools = new JavaTextTools(PreferenceConstants.getPreferenceStore());
		_methodViewer = new SourceViewer(this, null, null, false, ProbekitWidgetFactory.BORDER_STYLE | SWT.V_SCROLL | SWT.H_SCROLL | SWT.MULTI);
		_methodViewerConfiguration = new JavaSourceViewerConfiguration(_javaTextTools.getColorManager(), PreferenceConstants.getPreferenceStore(), null, null);
		_methodViewer.configure(_methodViewerConfiguration);
		IDocument document= new Document();
		
		// setup Java partitioner
		IDocumentPartitioner partitioner = _javaTextTools.createDocumentPartitioner();
		document.setDocumentPartitioner(partitioner);
		partitioner.connect(document);
		
		_methodViewer.setDocument(document);
		_methodViewer.setEditable(true);
		GridData descLayout = GridUtil.createFill();
		_methodViewer.getTextWidget().setLayoutData(descLayout);
		
		// add listeners - don't change the order in which the listeners are
		// added
		// because of team support issues modify listeners should always be the
		// last one added
		addFocusListenerTo(_methodViewer.getTextWidget());
		
		_methodViewer.getTextWidget().addModifyListener(new CodeModifyListener());
	}
	
	protected void createTitle(Composite parent) {
		widgetFactory.createLabel(parent, ProbekitMessages._18, SWT.NONE);
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.probekit.internal.presentation.IDetails#display(org.eclipse.emf.ecore.EObject)
	 */
	public void display(Object object) {
		if (_methodViewer.getTextWidget().isFocusControl())
			return;
		currentSelection = (Probe) object;
		isDisplaying = true;
		_methodViewer.getTextWidget().setText(currentSelection.getFragmentAtClassScope() == null ? "" : currentSelection.getFragmentAtClassScope());
//		setFocusToText();
		isDisplaying = false;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.probekit.internal.presentation.IDetails#updateCurrentSelection(org.eclipse.emf.ecore.EObject)
	 */
	public boolean updateCurrentSelection(Object currentSelection) {
		this.currentSelection = (Probe) currentSelection;
		this.currentSelection.setFragmentAtClassScope(_methodViewer.getTextWidget().getText());
		return false;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.probekit.internal.presentation.IDetails#isDetailsFor(java.lang.Object)
	 */
	public boolean isDetailsFor(Object object) {
		if (object instanceof Probe || object instanceof ProbeImpl) {
			return true;
		}
		return false;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.probekit.internal.presentation.IDetails#setFocusTo()
	 */
	public void setFocusTo() {
		setFocusToText();
	}

	public void setFocusToText() {
		_methodViewer.getTextWidget().setFocus();
	}

	private class CodeModifyListener implements ModifyListener {
		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
		 */
		public void modifyText(ModifyEvent e) {
			if (currentSelection == null)
				return;
			if (e.getSource() == _methodViewer.getTextWidget()) {
				String text = _methodViewer.getTextWidget().getText();
				if (!text.equals(currentSelection.getFragmentAtClassScope())) {
					if (text.length() == 0 && currentSelection.getFragmentAtClassScope() == null)
						return;
					IItemPropertyDescriptor descriptor = itemProvider.getPropertyDescriptor(currentSelection, ProbekitPackage.eINSTANCE.getProbe_FragmentAtClassScope());
					if (descriptor != null)
						descriptor.setPropertyValue(currentSelection, text);
				}
			}
		}
	}
	
	public void refresh() {
	}
}