/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: InvocationObjectDetails.java,v 1.3 2008/05/29 21:14:11 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit.editor.internal.presentation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.hyades.models.internal.probekit.InvocationObject;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.models.internal.probekit.impl.InvocationObjectImpl;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.provider.InvocationObjectItemProvider;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class InvocationObjectDetails extends BaseDetails implements ModifyListener {
	protected final EAttribute NAME = ProbekitPackage.eINSTANCE.getInvocationObject_Name();
	protected Text invocationObjectText;
	protected boolean isDisplaying;
	protected InvocationObject currentSelection;
	protected InvocationObjectItemProvider itemProvider;
	protected ProbekitItemProviderAdapterFactory itemFactory;
	public InvocationObjectDetails(ProbekitWidgetFactory factory, ProbekitItemProviderAdapterFactory itemFactory, Composite composite, int style) {
		super(composite, style);
		this.itemFactory = itemFactory;
		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 1;
		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
		factory.createLabel(this, ProbekitMessages._21, SWT.NONE);
		invocationObjectText = factory.createText(this, "", SWT.NONE);
		invocationObjectText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		// invocationObjectText.setData(new Integer(0));
		// add listeners - don't change the order in which the listeners are
		// added
		// because of team support issues modify listeners should always be the
		// last one added
		invocationObjectText.addModifyListener(this);
		itemProvider = (InvocationObjectItemProvider) itemFactory.createInvocationObjectAdapter();
		
		addFocusListenerTo(invocationObjectText);

	}
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(Object object) {
		if (invocationObjectText.isFocusControl())
			return;
		currentSelection = (InvocationObject) object;
		isDisplaying = true;
		invocationObjectText.setText(currentSelection.getName() == null ? "" : currentSelection.getName());
		isDisplaying = false;
	}
	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(Object currentSelection) {
		this.currentSelection = (InvocationObject) currentSelection;
		this.currentSelection.setName(invocationObjectText.getText().trim());
		return false;
	}
	public void setFocusToText() {
		invocationObjectText.setFocus();
		invocationObjectText.selectAll();
	}
	/**
	 * Sent when the text is modified.
	 * 
	 * @param e
	 *            an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e) {
		if (currentSelection == null)
			return;
		if (e.getSource() == invocationObjectText) {
			String text = invocationObjectText.getText().trim();
			if (!text.equals(currentSelection.getName())) {
				if (text.length() == 0 && currentSelection.getName() == null)
					return;
				IItemPropertyDescriptor descriptor = itemProvider.getPropertyDescriptor(currentSelection, NAME);
				if (descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);
			}
		}
	}
	public void dispose() {
		itemFactory = null;
		itemProvider = null;
		invocationObjectText = null;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.probekit.internal.presentation.IDetails#isDetailsFor(java.lang.Object)
	 */
	public boolean isDetailsFor(Object object) {
		if (object instanceof InvocationObject || object instanceof InvocationObjectImpl) {
			return true;
		}
		return false;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.probekit.internal.presentation.IDetails#setFocusTo()
	 */
	public void setFocusTo() {
		setFocusToText();
	}
	
	public void refresh() {
	}
}