/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LabelDialog.java,v 1.2 2005/12/30 02:58:09 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.hyades.probekit.editor.internal.presentation;

import org.eclipse.hyades.models.internal.probekit.Label;
import org.eclipse.hyades.models.internal.probekit.ProbekitFactory;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.core.util.ResourceUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;



class LabelDialog extends Dialog {
	private String _title = null;
	private Text _name = null;
	private Text _description = null;
	private Combo _combo = null;
	private Label _label = null;
	private String[] _languages = null;
	private Label _default = null;
	
	public LabelDialog(Shell shell, String[] languages, Label label) {
		super(shell);
		int shellStyle = getShellStyle();
		setShellStyle(shellStyle | SWT.RESIZE | SWT.BORDER);
		_label = ProbekitFactory.eINSTANCE.createLabel();
		_label.setLang(label.getLang());
		_label.setName(label.getName());
		_label.setDescription(label.getDescription());
		
		_default = label;
		
		_languages = languages;
	}
	
	public Label getResult() {
		if(getReturnCode() == Window.CANCEL) {
			return _default;
		}
		else {
			return getLabel();
		}
	}
	
	public Label getLabel() {
		return _label;
	}
	
	private String[] getLanguages() {
		return _languages;
	}
	
	void update() {
		String name = _name.getText();
		getLabel().setName(name);
		
		String language = _combo.getText();
		getLabel().setLang(language);

		String description = _description.getText();
		getLabel().setDescription(description);
	}
	
	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite)super.createDialogArea(parent);
		GridLayout layout = new GridLayout();
		GridData data = new GridData(GridData.FILL_BOTH);
		composite.setLayout(layout);
		composite.setLayoutData(data);
		
		return createDialogContents(composite);
	}
	
	protected Composite createDialogContents(Composite parent) {
		// I'm not sure why, but to navigate through this Dialog's Text
		// widgets, you need to type Ctrl-Tab instead of Tab alone. See
		// org.eclipse.swt.widgets.Control::translateTraversal(MSG),
		// block "case OS.VK_TAB:".
		LabelModifyListener listener = new LabelModifyListener();

		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		GridData data = new GridData(GridData.FILL_BOTH);
		data.widthHint = 300;
		composite.setLayout(layout);
		composite.setLayoutData(data);
		
		org.eclipse.swt.widgets.Label nameLabel = new org.eclipse.swt.widgets.Label(composite, SWT.WRAP);
		nameLabel.setText(ProbekitMessages._112);
		GridData nameLabelData = new GridData();
		nameLabel.setLayoutData(nameLabelData);
		
		_name = new Text(composite, SWT.BORDER);
		_name.setText(ResourceUtil.getString(getLabel().getName()));
		GridData nameData = GridUtil.createHorizontalFill();
		_name.setLayoutData(nameData);
		_name.addModifyListener(listener);
		
		org.eclipse.swt.widgets.Label comboLabel = new org.eclipse.swt.widgets.Label(composite, SWT.WRAP);
		comboLabel.setText(ProbekitMessages._113);
		
		_combo = new Combo(composite, SWT.SINGLE);
		GridData comboData = GridUtil.createHorizontalFill();
		_combo.setItems(getLanguages());
		_combo.setText(ResourceUtil.getString(getLabel().getLang()));
		_combo.setLayoutData(comboData);
		_combo.addModifyListener(listener);
		
		org.eclipse.swt.widgets.Label textLabel = new org.eclipse.swt.widgets.Label(composite, SWT.NULL);
		textLabel.setText(ProbekitMessages._114);
		textLabel.setLayoutData(GridUtil.createVerticalFill());
		
		_description = new Text(composite, SWT.BORDER | SWT.MULTI);
		_description.setText(ResourceUtil.getString(getLabel().getDescription()));
		GridData textData = GridUtil.createFill();
		textData.heightHint = 100;
		_description.setLayoutData(textData);
		_description.addModifyListener(listener);
		
		return composite;
	}

	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		if (getTitle() != null) {
			shell.setText(getTitle());
		}
	}
	
	private String getTitle() {
		return _title;
	}
	
	public void setTitle(String title) {
		_title = title;
	}
	
	private class LabelModifyListener implements ModifyListener {
		public void modifyText(ModifyEvent e) {
			update();
		}
	}
}
