/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProbekitActionBarContributor.java,v 1.6 2006/07/17 14:42:17 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit.editor.internal.presentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.hyades.models.internal.probekit.Probe;
import org.eclipse.hyades.models.internal.probekit.Probekit;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.presentation.ProbekitEditor.MyActionHandlerListener;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;

/**
 * This is the action bar contributor for the Probekit model editor. <!--
 * begin-user-doc --> <!-- end-user-doc -->
 * 
 * @generated
 */
public class ProbekitActionBarContributor extends EditingDomainActionBarContributor implements ISelectionChangedListener {
	/**
	 * This keeps track of the active editor. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected IEditorPart activeEditorPart;
	/**
	 * This keeps track of the current selection provider. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ISelectionProvider selectionProvider;
	
	protected Action addProbeAction;
	
	/**
	 * This action opens the Properties view. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected IAction showPropertiesViewAction = new Action(ProbekitMessages._31) {
		public void run() {
			try {
				getPage().showView("org.eclipse.ui.views.PropertySheet");
			} catch (PartInitException exception) {
				ProbekitUIPlugin.INSTANCE.log(exception);
			}
		}
	};
	/**
	 * This action refreshes the viewer of the current editor if the editor
	 * implements {@link IViewerProvider}. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected IAction refreshViewerAction = new Action(ProbekitMessages._32) {
		public boolean isEnabled() {
			return activeEditorPart instanceof IViewerProvider;
		}
		public void run() {
			if (activeEditorPart instanceof IViewerProvider) {
				Viewer viewer = ((IViewerProvider) activeEditorPart).getViewer();
				if (viewer != null) {
					viewer.refresh();
				}
			}
		}
	};
	/**
	 * This will contain one {@link CreateChildAction}corresponding to each
	 * descriptor generated for the current selection by the item provider. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected Collection createChildActions;
	/**
	 * This is the menu manager into which menu contribution items should be
	 * added for CreateChild actions. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	protected IMenuManager createChildMenuManager;
	//	/**
	//	 * This will contain one {@link CreateSiblingAction}corresponding to each
	//	 * descriptor generated for the current selection by the item provider.
	// <!--
	//	 * begin-user-doc --> <!-- end-user-doc -->
	//	 *
	//	 * @generated
	//	 */
	//	protected Collection createSiblingActions;
	/**
	 * This is the menu manager into which menu contribution items should be
	 * added for CreateSibling actions. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected IMenuManager createSiblingMenuManager;
	/**
	 * This creates an instance of the contributor. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public ProbekitActionBarContributor() {
	}
	/**
	 * This adds Separators for editor additions to the tool bar. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void contributeToToolBar(IToolBarManager toolBarManager) {
		toolBarManager.add(new Separator("probekit-settings"));
		toolBarManager.add(new Separator("probekit-additions"));
	}
	/**
	 * This adds to the menu bar a menu and some separators for editor
	 * additions, as well as the sub-menus for object creation items. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void contributeToMenu(IMenuManager menuManager) {
		super.contributeToMenu(menuManager);
		IMenuManager submenuManager = new MenuManager(ProbekitMessages._4, "org.eclipse.hyades.models.probekit.internal.probekitMenuID");
		menuManager.insertAfter("additions", submenuManager);
		submenuManager.add(new Separator("settings"));
		submenuManager.add(new Separator("actions"));
		submenuManager.add(new Separator("additions"));
		submenuManager.add(new Separator("additions-end"));
		// Prepare for CreateChild item addition or removal.
		//
		createChildMenuManager = new MenuManager(ProbekitMessages._3);
		submenuManager.insertBefore("additions", createChildMenuManager);
		// Prepare for CreateSibling item addition or removal.
		//
		createSiblingMenuManager = new MenuManager(ProbekitMessages._2);
		submenuManager.insertBefore("additions", createSiblingMenuManager);
		// Force an update because Eclipse hides empty menus now.
		//
		submenuManager.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager menuManager) {
				menuManager.updateAll(true);
			}
		});
		addGlobalActions(submenuManager);
		submenuManager.updateAll(true);
	}
	/**
	 * When the active editor changes, this remembers the change, and registers
	 * with it as a selection provider. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated NOT (added check for null)
	 */
	public void setActiveEditor(IEditorPart part) {
		super.setActiveEditor(part);
		activeEditorPart = part;
		// Switch to the new selection provider.
		//
		if (selectionProvider != null) {
			selectionProvider.removeSelectionChangedListener(this);
		}
		if (part == null) {
			selectionProvider = null;
		} else {
			selectionProvider = part.getSite().getSelectionProvider();
			if(selectionProvider != null) {
				selectionProvider.addSelectionChangedListener(this);
				// Fake a selection changed event to update the menus.
				//
				if (selectionProvider.getSelection() != null) {
					selectionChanged(new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection()));
				}
			}
		}
	}
	/**
	 * This implements {@link ISelectionChangedListener}, handling
	 * {@link SelectionChangedEvents}by querying for the children and siblings
	 * that can be added to the selected object and updating the menus
	 * accordingly. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void selectionChanged(SelectionChangedEvent event) {
		// Remove any menu items for old selection.
		//
		if (createChildMenuManager != null) {
			depopulateManager(createChildMenuManager, createChildActions);
		}
		// Query the new selection for appropriate new child/sibling descriptors
		//
		Collection newChildDescriptors = null;
		ISelection selection = event.getSelection();
		if (selection instanceof IStructuredSelection && ((IStructuredSelection) selection).size() == 1) {
			Object object = ((IStructuredSelection) selection).getFirstElement();
			EditingDomain domain = ((IEditingDomainProvider) activeEditorPart).getEditingDomain();
			newChildDescriptors = domain.getNewChildDescriptors(object, null);
		}
		// Generate actions for selection; populate and redraw the menus.
		//
		createChildActions = generateCreateChildActions(newChildDescriptors, selection);
		if (createChildMenuManager != null) {
			populateManager(createChildMenuManager, createChildActions, null);
			createChildMenuManager.update(true);
		}
	}
	/**
	 * This generates a {@link CreateChildAction}for each object in
	 * <code>descriptors</code>, and returns the collection of these actions.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected Collection generateCreateChildActions(Collection descriptors, ISelection selection) {
		Collection actions = new ArrayList();
		if (descriptors != null) {
			for (Iterator i = descriptors.iterator(); i.hasNext();) {
				actions.add(new CreateChildAction(activeEditorPart, selection, i.next()));
			}
		}
		return actions;
	}
	//		/**
	//		 * This generates a {@link CreateSiblingAction} for each object in
	//	 <code>descriptors</code>,
	//		 * and returns the collection of these actions.
	//		 * <!-- begin-user-doc -->
	//		 * <!-- end-user-doc -->
	//		 * @generated
	//		 */
	//		protected Collection generateCreateSiblingActions(Collection descriptors,
	//	 ISelection selection) {
	//			Collection actions = new LinkedList();
	//			if (descriptors != null) {
	//				for (Iterator i = descriptors.iterator(); i.hasNext(); ) {
	//					actions.add(new CreateSiblingAction(activeEditorPart, selection,
	//	 i.next()));
	//				}
	//			}
	//			return actions;
	//		}
	/**
	 * This populates the specified <code>manager</code> with
	 * {@link ActionContributionItem}s based on the {@link IAction}s contained
	 * in the <code>actions</code> collection, by inserting them before the
	 * specified contribution item <code>contributionID</code>. If
	 * <code>ID</code> is <code>null</code>, they are simply added. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void populateManager(IContributionManager manager, Collection actions, String contributionID) {
		if (actions != null) {
			for (Iterator i = actions.iterator(); i.hasNext();) {
				IAction action = (IAction) i.next();
				if (contributionID != null) {
					manager.insertBefore(contributionID, action);
				} else {
					manager.add(action);
				}
			}
		}
	}
	/**
	 * This removes from the specified <code>manager</code> all
	 * {@link ActionContributionItem}s based on the {@link IAction}s contained
	 * in the <code>actions</code> collection. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected void depopulateManager(IContributionManager manager, Collection actions) {
		if (actions != null) {
			IContributionItem[] items = manager.getItems();
			for (int i = 0; i < items.length; i++) {
				// Look into SubContributionItems
				//
				IContributionItem contributionItem = items[i];
				while (contributionItem instanceof SubContributionItem) {
					contributionItem = ((SubContributionItem) contributionItem).getInnerItem();
				}
				// Delete the ActionContributionItems with matching action.
				//
				if (contributionItem instanceof ActionContributionItem) {
					IAction action = ((ActionContributionItem) contributionItem).getAction();
					if (actions.contains(action)) {
						manager.remove(contributionItem);
					}
				}
			}
		}
	}
	/**
	 * This populates the pop-up menu before it appears. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void menuAboutToShow(IMenuManager menuManager) {
		super.menuAboutToShow(menuManager);
		MenuManager submenuManager = null;
		
		if(addProbeAction == null && activeEditorPart != null && activeEditorPart instanceof ProbekitEditor)
		{
			addProbeAction = new Action(ProbekitMessages._122) {
				
				public void run()
				{
					((ProbekitEditor)activeEditorPart).addProbe();
				}
			};
			
		}
		if(addProbeAction != null && selectionProvider != null)
		{
			ISelection sel = selectionProvider.getSelection();
			
			if(sel == null || sel.isEmpty() ||
			   (((IStructuredSelection)sel).getFirstElement() instanceof Probe))	
				menuManager.insertBefore("additions", addProbeAction);				
			    menuManager.insertBefore("additions", new Separator());					
		}
		
		submenuManager = new MenuManager(ProbekitMessages._3);
		populateManager(submenuManager, createChildActions, null);
		menuManager.insertBefore("additions", submenuManager);
		
	}
	/**
	 *  
	 */
	public void replaceGlobalActions(IActionBars actionBars,MyActionHandlerListener actionHandlerListener) {
		actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), null);
		actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), null);
		actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
		actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
		actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), null);
		actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), null);
		actionHandlerListener.connectCutCopyPasteActions(actionBars);
		actionBars.updateActionBars();
	}
	/**
	 * @param actionBars
	 */
	public void resetGlobalActions(IActionBars actionBars) {
		actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), deleteAction);
		actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), cutAction);
		actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), copyAction);
		actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), pasteAction);
		actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), undoAction);
		actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), redoAction);
		if (activeEditor != null) {
			ISelectionProvider selectionProvider = activeEditor instanceof ISelectionProvider ? (ISelectionProvider) activeEditor : activeEditor.getEditorSite().getSelectionProvider();
			selectionProvider.addSelectionChangedListener(deleteAction);
			selectionProvider.addSelectionChangedListener(cutAction);
			selectionProvider.addSelectionChangedListener(copyAction);
			selectionProvider.addSelectionChangedListener(pasteAction);
		}
		actionBars.updateActionBars();
	}
	/**
	 * This inserts global actions before the "additions-end" separator. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addGlobalActions(IMenuManager menuManager) {
		menuManager.insertAfter("additions-end", new Separator("ui-actions"));
		menuManager.insertAfter("ui-actions", showPropertiesViewAction);
		super.addGlobalActions(menuManager);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor#init(org.eclipse.ui.IActionBars)
	 */
	public void init(IActionBars actionBars) {
		// TODO Auto-generated method stub
		super.init(actionBars);
		
		//replace delete action
		ImageDescriptor id = deleteAction.getImageDescriptor();
	    deleteAction = new DeleteAction(){
			/* (non-Javadoc)
			 * @see org.eclipse.emf.edit.ui.action.CommandActionHandler#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
			 */
			public boolean updateSelection(IStructuredSelection selection) {
				if(selection.getFirstElement() instanceof Probekit)
				{
					return false;
				}
				else
				{
					return super.updateSelection(selection);
				}
			}
			
	    };
	    deleteAction.setImageDescriptor(id);
	    actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), deleteAction);
		//replace cut action
		id = deleteAction.getImageDescriptor();
	    cutAction = new CutAction(){
			/* (non-Javadoc)
			 * @see org.eclipse.emf.edit.ui.action.CommandActionHandler#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
			 */
			public boolean updateSelection(IStructuredSelection selection) {
				if(selection.getFirstElement() instanceof Probekit)
				{
					return false;
				}
				else
				{
					return super.updateSelection(selection);
				}
			}
			
	    };
	    cutAction.setImageDescriptor(id);
	    actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), cutAction);

	}
}