/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProbekitContentProvider.java,v 1.1 2005/06/07 04:04:15 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.hyades.probekit.editor.internal.presentation;

import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.hyades.models.internal.probekit.Probekit;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;


public class ProbekitContentProvider implements ITreeContentProvider {
	private AdapterFactoryContentProvider _contentProvider;
	
	public ProbekitContentProvider(AdapterFactoryContentProvider contentProvider) {
		_contentProvider = contentProvider;
	}
	
	protected AdapterFactoryContentProvider getDelegate() {
		return _contentProvider;
	}

	public Object[] getChildren(Object parentElement) {
		return getDelegate().getChildren(parentElement);
	}
	
	public Object getParent(Object element) {
		return getDelegate().getParent(element);
	}
	
	public boolean hasChildren(Object element) {
		return getChildren(element).length > 0;
	}
	
	public Object[] getElements(Object inputElement) {
		return ((Probekit)inputElement).getProbe().toArray();
	}
	
	public void dispose() {
		getDelegate().dispose();
	}
	
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		getDelegate().inputChanged(viewer, oldInput, newInput);
	}
}
