/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProbekitDetailsViewer.java,v 1.1 2005/06/07 04:04:15 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit.editor.internal.presentation;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

// TTT testing

/**
 * @author tova
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class ProbekitDetailsViewer
	extends Viewer
	implements ISelectionChangedListener {
		
	protected ProbekitWidgetFactory widgetFactory;
	protected ProbekitItemProviderAdapterFactory factory;
	protected DetailsContent details;	
	protected Composite result;
	
	/**
	 * 
	 */
	public ProbekitDetailsViewer(
		Composite parent,
		ProbekitItemProviderAdapterFactory factory,
		ProbekitWidgetFactory widgetFactory) {
		super();

		this.factory = factory;
		this.widgetFactory = new ProbekitWidgetFactory();

		result =  this.widgetFactory.createComposite(parent);
		GridLayout detailLayout = new GridLayout();
		result.setLayout(detailLayout);
		result.setLayoutData(GridUtil.createFill());

		createHeader(result);

		details = new DetailsContent(this.widgetFactory, this.factory, result, SWT.NONE);
		details.createContent();
		this.widgetFactory.createCompositeSeparator(result);

		widgetFactory.paintChildControlsFor(result);
 	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.Viewer#getControl()
	 */
	public Control getControl() {
		return result;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IInputProvider#getInput()
	 */
	public Object getInput() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ISelectionProvider#getSelection()
	 */
	public ISelection getSelection() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.Viewer#refresh()
	 */
	public void refresh() {
		details.refresh();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.Viewer#setInput(java.lang.Object)
	 */
	public void setInput(Object input) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.Viewer#setSelection(org.eclipse.jface.viewers.ISelection, boolean)
	 */
	public void setSelection(ISelection selection, boolean reveal) {
	}

	/**
	 * Notifies that the selection has changed.
	 *
	 * @param event event object describing the change
	 */
	public void selectionChanged(SelectionChangedEvent event) {
		
		if (event.getSource() != null
			&& event.getSource() instanceof ProbekitEditor) {

            ISelection selection = event.getSelection();
            showSelection(selection);
		}
		
	}
	
	private void showSelection(ISelection selection) {
        Object currentSelection = null;
		if(selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
			currentSelection = ((IStructuredSelection)selection).getFirstElement();	
		}
		
		if(currentSelection instanceof EObject) {
			details.showDetailsFor(currentSelection);
		}
        else if(currentSelection instanceof WrapperItemProvider)
        {
        	Object value = ((WrapperItemProvider)currentSelection).getValue();
        	if(value!=null && value instanceof FeatureMapUtil.EntryImpl)
        		value = ((FeatureMapUtil.EntryImpl)value).getValue();
        	if(value != null && value instanceof EObject)
        		details.showDetailsFor(value);
        }
        else if(currentSelection instanceof EObjectContainmentEList) {
        	EObjectContainmentEList list = (EObjectContainmentEList)currentSelection;
        	details.showDetailsFor(list);
        }
	    else {
	       details.showDetailsFor(null);		
	    }
	}

	public void dispose() {
		
		if(widgetFactory != null)
		  widgetFactory.dispose();
		  
	    widgetFactory = null;
	    factory = null;	
	    
	    if(details != null)
	      details.dispose();  
	}

	private void createHeader(Composite content){

		this.widgetFactory.createCompositeSeparator(content);

	}
	
}
