/**********************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProbekitEditor.java,v 1.11 2010/05/19 19:27:54 jwest Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit.editor.internal.presentation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.hyades.models.internal.probekit.DataItem;
import org.eclipse.hyades.models.internal.probekit.DocumentRoot;
import org.eclipse.hyades.models.internal.probekit.Probe;
import org.eclipse.hyades.models.internal.probekit.Probekit;
import org.eclipse.hyades.models.internal.probekit.ProbekitFactory;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.probekit.IProbeCompiler;
import org.eclipse.hyades.probekit.ProbekitCompileProblemException;
import org.eclipse.hyades.probekit.ProbekitException;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.core.util.ResourceUtil;
import org.eclipse.hyades.probekit.editor.internal.presentation.codeassist.JavaSnippet;
import org.eclipse.hyades.probekit.editor.internal.presentation.codeassist.SyntaxAdapter;
import org.eclipse.hyades.probekit.editor.internal.provider.EObjectListSwitch;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.hyades.probekit.editor.internal.ui.DialogUtil;
import org.eclipse.hyades.probekit.ui.internal.ContextIds;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;
import org.eclipse.hyades.ui.internal.editor.action.ActionHandlerListener;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.xml.sax.SAXParseException;
/**
 * This is an example of a Probekit model editor. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * 
 * @generated NOT
 */
public class ProbekitEditor extends MultiPageEditorPart implements IEditingDomainProvider, ISelectionProvider, IMenuListener 
							, IResourceChangeListener, IResourceDeltaVisitor{

	private GeneralTab _generalTab = null;
	private Composite _probesTab = null;
	private int _generalTabIndex;
	private int _probesTabIndex;
	
	private boolean _hasSyntaxBeenChecked = false;
	private Composite _errorComposite = null;
	private TableViewer _syntaxErrors = null;
	private TableColumn _iconColumn = null;
	private TableColumn _descriptionColumn = null;
	private TableColumn _resourceColumn = null;
	private SyntaxViewerSorter _syntaxErrorSorter = null;
	private Label _syntaxErrorTitle = null;
	protected final String[] COLUMNS = new String[]{
		ResourceUtil.NO_TEXT,
		ProbekitMessages._135, 
		ProbekitMessages._136
	};
	protected List _jdtProblems = null;
	protected JavaSnippet _snippet = null;
	IFile file;
	
	private boolean isActivating;
	
	/**
	 * @author slavescu
	 * 
	 * TODO To change the template for this generated type comment go to Window -
	 * Preferences - Java - Code Style - Code Templates
	 */
	public class MyActionHandlerListener extends ActionHandlerListener {
		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.hyades.ui.internal.editor.action.ActionHandlerListener#connectCutCopyPasteActions(org.eclipse.ui.IActionBars)
		 */
		public void connectCutCopyPasteActions(IActionBars actionBars) {
			super.connectCutCopyPasteActions(actionBars);
		}
	}
	
	private class MyCommandStackListener implements CommandStackListener {
		public void commandStackChanged(final EventObject event) {
			getContainer().getDisplay().asyncExec(new Runnable() {
				public void run() {
					firePropertyChange(IEditorPart.PROP_DIRTY);
					// Try to select the affected objects.
					Command mostRecentCommand = ((CommandStack) event.getSource()).getMostRecentCommand();
					if (mostRecentCommand != null) {
						setSelectionToViewer(mostRecentCommand.getAffectedObjects());
					}
					if (propertySheetPage != null && !propertySheetPage.getControl().isDisposed()) {
						propertySheetPage.refresh();
					}
				}
			});
		}
	}
	
	private class SyntaxContentProvider implements IStructuredContentProvider {
		public void dispose() {
		}

		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}

		public Object[] getElements(Object inputElement) {
			return ((List)inputElement).toArray();
		}
	}
	
	private class SyntaxColumnLabelProvider extends LabelProvider implements ITableLabelProvider {
		public Image getColumnImage(Object element, int columnIndex) {
			IProblem problem = (IProblem)element;
			if(columnIndex == 0) {
				return DialogUtil.getImage(JavaSnippet.getIconURL(problem));
			}
			else {
				return null;
			}
		}
		
		public String getColumnText(Object element, int columnIndex) {
			IProblem problem = (IProblem)element;
			if(columnIndex == 0) {
				// icon column
				return ResourceUtil.NO_TEXT;
			}
			else if(columnIndex == 1) {
				// Description column
				return problem.getMessage();
			}
			else {
				// Resource column
				EObject eObject = _snippet.getEObject(problem);
				if(eObject == null) {
					return ResourceUtil.NO_TEXT;
				}
				IItemLabelProvider labelProvider = (IItemLabelProvider)itemProviderFactory.adapt(eObject, IItemLabelProvider.class);
				if(labelProvider == null) {
					return ResourceUtil.NO_TEXT;
				}
				else {
					return labelProvider.getText(eObject);
				}
			}
		}
	}
	
	private class SyntaxMouseClickListener implements MouseListener {
		public void mouseDoubleClick(MouseEvent e) {
			Table table = (Table)e.widget;
			int index = table.getSelectionIndex();
			TableItem item = table.getItem(index);
			IProblem problem = (IProblem)item.getData();
			select(problem);
		}

		public void mouseDown(MouseEvent e) {
		}

		public void mouseUp(MouseEvent e) {
		}
	}
	
	private class SyntaxSelectionListener implements SelectionListener {
		public void widgetDefaultSelected(SelectionEvent e) {
			// Nothing to do when the default is selected.
		}

		public void widgetSelected(SelectionEvent event) {
			TableItem item = (TableItem)event.item;
			IProblem problem = (IProblem)item.getData();
			select(problem);
		}
	}
	
	private class SyntaxHeaderListener implements SelectionListener {
		public void widgetDefaultSelected(SelectionEvent e) {
			// Nothing to do when the default is selected.
		}

		public void widgetSelected(SelectionEvent event) {
			SyntaxViewerSorter sorter = (SyntaxViewerSorter)_syntaxErrors.getSorter();
			if(event.widget == _iconColumn) {
				sorter.setSortBy(COLUMNS[0]);
			}
			else if(event.widget == _descriptionColumn) {
				sorter.setSortBy(COLUMNS[1]);
			}
			else if(event.widget == _resourceColumn) {
				sorter.setSortBy(COLUMNS[2]);
			}
			_syntaxErrors.setSorter(sorter);
			_syntaxErrors.refresh();
		}
	}
	
	private class SyntaxViewerSorter extends ViewerSorter {
		private Comparator _iconAscendingComparator = new Comparator() {
			public int compare(Object a, Object b) {
				if((a == null) && (b == null)) {
					return 0;
				}
				else if(a == null) {
					return 1;
				}
				else if(b == null) {
					return -1;
				}
				
				IProblem aProblem = (IProblem)a;
				IProblem bProblem = (IProblem)b;
				if(aProblem.isError() && bProblem.isError()) {
					return 0;
				}
				else if(bProblem.isError()) {
					return 1;
				}
				return -1;
			}
		};
		private Comparator _iconDescendingComparator= new Comparator() {
			public int compare(Object a, Object b) {
				if((a == null) && (b == null)) {
					return 0;
				}
				else if(a == null) {
					return 1;
				}
				else if(b == null) {
					return -1;
				}
				
				IProblem aProblem = (IProblem)a;
				IProblem bProblem = (IProblem)b;
				if(aProblem.isWarning() && bProblem.isWarning()) {
					return 0;
				}
				else if(bProblem.isWarning()) {
					return 1;
				}
				return -1;
			}
		};
		private Comparator _descriptionAscendingComparator= new Comparator() {
			public int compare(Object a, Object b) {
				if((a == null) && (b == null)) {
					return 0;
				}
				else if(a == null) {
					return 1;
				}
				else if(b == null) {
					return -1;
				}
				
				IProblem aProblem = (IProblem)a;
				IProblem bProblem = (IProblem)b;
				SyntaxColumnLabelProvider labelProvider = (SyntaxColumnLabelProvider)_syntaxErrors.getLabelProvider();
				String aDesc = labelProvider.getColumnText(aProblem, 1);
				String bDesc = labelProvider.getColumnText(bProblem, 1);
				return aDesc.compareTo(bDesc);
			}
		};
		private Comparator _descriptionDescendingComparator= new Comparator() {
			public int compare(Object a, Object b) {
				if((a == null) && (b == null)) {
					return 0;
				}
				else if(a == null) {
					return 1;
				}
				else if(b == null) {
					return -1;
				}
				
				IProblem aProblem = (IProblem)a;
				IProblem bProblem = (IProblem)b;
				SyntaxColumnLabelProvider labelProvider = (SyntaxColumnLabelProvider)_syntaxErrors.getLabelProvider();
				String aDesc = labelProvider.getColumnText(aProblem, 1);
				String bDesc = labelProvider.getColumnText(bProblem, 1);
				int result = aDesc.compareTo(bDesc);
				if(result < 0) {
					return 1;
				}
				else if(result > 0) {
					return -1;
				}
				return 0;
			}
		};
		private Comparator _resourceAscendingComparator= new Comparator() {
			public int compare(Object a, Object b) {
				if((a == null) && (b == null)) {
					return 0;
				}
				else if(a == null) {
					return 1;
				}
				else if(b == null) {
					return -1;
				}
				
				IProblem aProblem = (IProblem)a;
				IProblem bProblem = (IProblem)b;
				SyntaxColumnLabelProvider labelProvider = (SyntaxColumnLabelProvider)_syntaxErrors.getLabelProvider();
				String aDesc = labelProvider.getColumnText(aProblem, 2);
				String bDesc = labelProvider.getColumnText(bProblem, 2);
				return aDesc.compareTo(bDesc);
			}
		};
		private Comparator _resourceDescendingComparator= new Comparator() {
			public int compare(Object a, Object b) {
				if((a == null) && (b == null)) {
					return 0;
				}
				else if(a == null) {
					return 1;
				}
				else if(b == null) {
					return -1;
				}
				
				IProblem aProblem = (IProblem)a;
				IProblem bProblem = (IProblem)b;
				SyntaxColumnLabelProvider labelProvider = (SyntaxColumnLabelProvider)_syntaxErrors.getLabelProvider();
				String aDesc = labelProvider.getColumnText(aProblem, 2);
				String bDesc = labelProvider.getColumnText(bProblem, 2);
				int result = aDesc.compareTo(bDesc);
				if(result < 0) {
					return 1;
				}
				else if(result > 0) {
					return -1;
				}
				return 0;
			}
		};
		private Comparator _currentComparator = _resourceAscendingComparator; // Default to sorting by ascending resource (aka probekit element) item text.
		
		public void setSortBy(String column) {
			if(COLUMNS[0].equals(column)) {
				if(_currentComparator.equals(_iconAscendingComparator)) {
					_currentComparator = _iconDescendingComparator;
				}
				else {
					_currentComparator = _iconAscendingComparator;
				}
			}
			else if(COLUMNS[1].equals(column)) {
				if(_currentComparator.equals(_descriptionAscendingComparator)) {
					_currentComparator = _descriptionDescendingComparator;
				}
				else {
					_currentComparator = _descriptionAscendingComparator;
				}
			}
			else if(COLUMNS[2].equals(column)) {
				if(_currentComparator.equals(_resourceAscendingComparator)) {
					_currentComparator = _resourceDescendingComparator;
				}
				else {
					_currentComparator = _resourceAscendingComparator;
				}
			}
		}
		
		public int compare(Viewer viewer, Object e1, Object e2) {
			return _currentComparator.compare(e1, e2);
		}
	}
	
	
	protected ProbekitWidgetFactory widgetFactory;
	protected ProbekitItemProviderAdapterFactory itemProviderFactory;
	/**
	 * This keeps track of the active viewer pane, in the book. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ViewerPane currentViewerPane;
	
	/**
	 * This keeps track of the active content viewer, which may be either one of
	 * the viewers in the pages or the content outline viewer. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected Viewer currentViewer;
	
	/**
	 * This is the viewer that shadows the selection in the content outline. The
	 * parent relation must be correctly defined for this to work. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected TreeViewer selectionViewer;
	
	/**
	 * This keeps track of the editing domain that is used to track all changes
	 * to the model. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected AdapterFactoryEditingDomain editingDomain;
	/**
	 * This is the one adapter factory used for providing views of the model.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ComposedAdapterFactory adapterFactory;
	/**
	 * This is a kludge... <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected IStatusLineManager contentOutlineStatusLineManager;
	/**
	 * This is the content outline page's viewer. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected TreeViewer contentOutlineViewer;
	/**
	 * This is the property sheet page. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected PropertySheetPage propertySheetPage;

	protected ProbekitDetailsViewer detailsViewer;
	/**
	 * This listens to which ever viewer is active. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected ISelectionChangedListener selectionChangedListener;
	/**
	 * This keeps track of all the
	 * {@link org.eclipse.jface.viewers.ISelectionChangedListener}s that are
	 * listening to this editor. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected Collection selectionChangedListeners = new ArrayList();
	//	protected Collection selectionChangedListeners = new ArrayList();
	/**
	 * This keeps track of the selection of the editor as a whole. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ISelection editorSelection;
	/**
	 * This listens for when the outline becomes active <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected IPartListener partListener = new IPartListener() {
		public void partActivated(IWorkbenchPart p) {
			if (p instanceof PropertySheet) {
				if (((PropertySheet) p).getCurrentPage() == propertySheetPage) {
					getActionBarContributor().setActiveEditor(ProbekitEditor.this);
					handleActivate();
				}
			} else if (p == ProbekitEditor.this) {
				handleActivate();
			}
		}
		public void partBroughtToTop(IWorkbenchPart p) {
		}
		public void partClosed(IWorkbenchPart p) {
		}
		public void partDeactivated(IWorkbenchPart p) {
		}
		public void partOpened(IWorkbenchPart p) {
		}
	};
	/**
	 * Resources that have been removed since last activation.
	 * 
	 * @generated
	 */
	Collection removedResources = new ArrayList();
	/**
	 * Resources that have been changed since last activation.
	 * 
	 * @generated
	 */
	Collection changedResources = new ArrayList();
	/**
	 * Resources that have been saved.
	 * 
	 * @generated
	 */
	Collection savedResources = new ArrayList();
	private MyActionHandlerListener actionHandlerListener;

	/**
	 * Handles activation of the editor or it's associated views.
	 * 
	 * @generated
	 */
	protected void handleActivate() {
		if (!removedResources.isEmpty()) {
			if (handleDirtyConflict()) {
				getSite().getPage().closeEditor(ProbekitEditor.this, false);
				ProbekitEditor.this.dispose();
			} else {
				removedResources.clear();
				changedResources.clear();
				savedResources.clear();
			}
		} else if (!changedResources.isEmpty()) {
			changedResources.removeAll(savedResources);
			handleChangedResources();
			changedResources.clear();
			savedResources.clear();
		}
	}
	/**
	 * Handles what to do with changed resources on activation.
	 * 
	 * @generated
	 */
	protected void handleChangedResources() {
		if (!changedResources.isEmpty() && (!isDirty() || handleDirtyConflict())) {
			editingDomain.getCommandStack().flush();
			for (Iterator i = changedResources.iterator(); i.hasNext();) {
				Resource resource = (Resource) i.next();
				if (resource.isLoaded()) {
					resource.unload();
					try {
						resource.load(Collections.EMPTY_MAP);
					} catch (IOException exception) {
						ProbekitUIPlugin.INSTANCE.log(exception);
					}
				}
			}
		}
	}
	/**
	 * Shows a dialog that asks if conflicting changes should be discarded.
	 * 
	 * @generated
	 */
	protected boolean handleDirtyConflict() {
		return MessageDialog.openQuestion(getSite().getShell(), ProbekitMessages._10, ProbekitMessages._9);
	}
	/**
	 * This creates a model editor. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	public ProbekitEditor() {
		super();
		// Create an adapter factory that yields item providers.
		//
		List factories = new ArrayList();
		factories.add(new ResourceItemProviderAdapterFactory());
		itemProviderFactory = new ProbekitItemProviderAdapterFactory();
		factories.add(itemProviderFactory);
		factories.add(new ReflectiveItemProviderAdapterFactory());
		adapterFactory = new EObjectListAdapterFactory(factories);
		// Create the command stack that will notify this editor as commands are
		// executed.
		//
		BasicCommandStack commandStack = new BasicCommandStack();
		// Add a listener to set the most recent command's affected objects to
		// be the selection of the viewer with focus.
		//
		commandStack.addCommandStackListener(new MyCommandStackListener());

		// Create the editing domain with a special command stack.
		//
		editingDomain = new EObjectListAdapterFactoryEditingDomain(adapterFactory, commandStack);
		actionHandlerListener = new MyActionHandlerListener();
		_jdtProblems = new ArrayList();
	}
	/**
	 * This is here for the listener to be able to call it. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void firePropertyChange(int action) {
		super.firePropertyChange(action);
	}
	/**
	 * This returns the editing domain as required by the
	 * {@link IEditingDomainProvider}interface. This is important for
	 * implementing the static methods of {@link AdapterFactoryEditingDomain}
	 * and for supporting {@link org.eclipse.emf.edit.ui.action.CommandAction}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EditingDomain getEditingDomain() {
		return editingDomain;
	}

	public ResourceLocator getResourceLocator() {
		return ProbekitUIPlugin.INSTANCE;
	}

	/**
	 * This creates a context menu for the viewer and adds a listener as well
	 * registering the menu for extension. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected void createContextMenuFor(StructuredViewer viewer) {
		MenuManager contextMenu = new MenuManager("#PopUp");
		contextMenu.add(new Separator("additions"));
		contextMenu.setRemoveAllWhenShown(true);
		contextMenu.addMenuListener(this);
		Menu menu = contextMenu.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		int dndOperations = DND.DROP_COPY | DND.DROP_MOVE | DND.DROP_LINK;
		Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
		viewer.addDragSupport(dndOperations, transfers, new ViewerDragAdapter(viewer));
		viewer.addDropSupport(dndOperations, transfers, new EditingDomainViewerDropAdapter(editingDomain, viewer));
	}

	public void createPages() {
		initializeFactories();

		Probekit probekit = getProbekit();
		List probes = getProbes();
		_snippet = new JavaSnippet(((IFileEditorInput)getEditorInput()).getFile(), probekit);

		_generalTabIndex = createGeneralPage(probekit);
		_probesTabIndex = createProbesPage(probes);

		setActivePage(_probesTabIndex);
	}
	
	private void initializeFactories() {
		// I assume that the input is a file object.
		//
		widgetFactory = new ProbekitWidgetFactory();
		IFileEditorInput modelFile = (IFileEditorInput) getEditorInput();
		Resource resource = null;
		try {
			// Load the resource through the editing domain.
			//
			resource = editingDomain.getResourceSet().getResource(URI.createPlatformResourceURI(modelFile.getFile().getFullPath().toString()), true);
		} catch (Exception exception) {
			if (exception instanceof WrappedException) {
				if (((WrappedException) exception).exception() instanceof SAXParseException) {
					if (modelFile.exists() && modelFile.getFile().getLocation().toFile().length() == 0) {
						resource = editingDomain.getResourceSet().getResource(URI.createPlatformResourceURI(modelFile.getFile().getFullPath().toString()), false);
						if (resource == null)
							resource = editingDomain.getResourceSet().createResource(URI.createPlatformResourceURI(modelFile.getFile().getFullPath().toString()));
						else {
							resource.getErrors().clear();
						}
						addProbekitElement(resource);
					}
				}
			}
			ProbekitUIPlugin.INSTANCE.log(exception);
		}
	}
	
	private int createGeneralPage(Probekit probekit) {
		_generalTab = new GeneralTab(editingDomain, getContainer(), SWT.NONE, probekit);
		addSelectionChangedListener(_generalTab.GENERAL_TAB_SELECTION_LISTENER);
		int index = addPage(_generalTab);
		setPageText(index, ProbekitMessages._128);
		return index;
	}
	
	private int createProbesPage(List probes) {
		_probesTab = createProbeTab(probes);
		int index = addPage(_probesTab);
		setPageText(index, ProbekitMessages._129);
		checkSyntax();
		return index;
	}

	protected Composite createProbeTab(List probes) {
		Composite parent = new Composite(getContainer(), SWT.NONE);
		parent.setLayoutData(GridUtil.createFill());
		GridLayout pageLayout = new GridLayout();
		pageLayout.numColumns = 2;
		parent.setLayout(pageLayout);
		
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayoutData(GridUtil.createFill());
		composite.setLayout(new GridLayout());

		SashForm errorForm = new SashForm(composite, SWT.VERTICAL);
		errorForm.setLayout(new GridLayout());
		errorForm.setLayoutData(GridUtil.createFill());
		
		SashForm sf = new SashForm(errorForm, SWT.HORIZONTAL) {
			public boolean setFocus() {
				return currentViewer.getControl().setFocus();
			}
			
		};
		
		sf.setLayout(new GridLayout());
		sf.setLayoutData(GridUtil.createFill());
		createProbeTree(sf, probes);
		createDetails(sf);
		sf.setWeights(new int[]{30, 70});
		
		
		createErrorSection(errorForm);
		errorForm.setWeights(new int[]{70, 30});
		
		return parent;
	}
	
	protected void createErrorSection(Composite parent) {
		SyntaxHeaderListener headerListener = new SyntaxHeaderListener();
		_errorComposite = new Composite(parent, SWT.NONE);
		GridData errorData = GridUtil.createFill();
		_errorComposite.setLayoutData(errorData);
		GridLayout layout = new GridLayout();
		_errorComposite.setLayout(layout);
		_errorComposite.setFont(parent.getFont());
		_errorComposite.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(SWT.COLOR_WHITE));

		_syntaxErrorTitle = new Label(_errorComposite, SWT.NONE);
		_syntaxErrorTitle.setLayoutData(new GridData());
		_syntaxErrorTitle.setBackground(_errorComposite.getBackground());
		_syntaxErrorTitle.setFont(_errorComposite.getFont());

		_syntaxErrors = new TableViewer(_errorComposite, SWT.BORDER | SWT.V_SCROLL | SWT.SINGLE | SWT.FULL_SELECTION );
		TableLayout tableLayout = new TableLayout();
		Table table = _syntaxErrors.getTable();
		
		_iconColumn = new TableColumn(table, SWT.LEFT);
		_iconColumn.setText(COLUMNS[0]);
		tableLayout.addColumnData(new ColumnWeightData(2));
		_iconColumn.addSelectionListener(headerListener);

		_descriptionColumn = new TableColumn(table, SWT.LEFT);
		_descriptionColumn.setText(COLUMNS[1]);
		tableLayout.addColumnData(new ColumnWeightData(80));
		_descriptionColumn.addSelectionListener(headerListener);
		
		_resourceColumn = new TableColumn(table, SWT.LEFT);
		_resourceColumn.setText(COLUMNS[2]);
		tableLayout.addColumnData(new ColumnWeightData(18));
		_resourceColumn.addSelectionListener(headerListener);

		_syntaxErrors.setContentProvider(new SyntaxContentProvider());
		_syntaxErrors.setLabelProvider(new SyntaxColumnLabelProvider());
		_syntaxErrors.setInput(getJDTProblems());
		_syntaxErrors.setColumnProperties(COLUMNS);
		_syntaxErrors.setSorter(getSyntaxErrorSorter());
		
		GridData tableData = new GridData(GridData.FILL_BOTH);
		table.setLayoutData(tableData);
		table.setLayout(tableLayout);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		table.setFont(_errorComposite.getFont());
		table.addMouseListener(new SyntaxMouseClickListener());
		table.addSelectionListener(new SyntaxSelectionListener());
	}
	
	protected SyntaxViewerSorter getSyntaxErrorSorter() {
		if(_syntaxErrorSorter == null) {
			_syntaxErrorSorter = new SyntaxViewerSorter();
		}
		return _syntaxErrorSorter;
	}
	
	protected void refreshSyntaxErrorMessage() {
		String errorCountMessage;
		String warningCountMessage;
		if(_hasSyntaxBeenChecked) {
			Resource resource = getProbekit().eResource();
			Iterator resourceIterator = resource.getAllContents();
			getJDTProblems().clear();
			int errorCount = 0;
			int warningCount = 0;
			while(resourceIterator.hasNext()) {
				EObject eObject = (EObject)resourceIterator.next();
				SyntaxAdapter adapter = JavaSnippet.getSyntaxAdapter(eObject);
				errorCount += adapter.errorCount();
				warningCount += adapter.warningCount();
				getJDTProblems().addAll(Arrays.asList(adapter.getKnownProblems()));
			}
			errorCountMessage = String.valueOf(errorCount);
			warningCountMessage = String.valueOf(warningCount);
		}
		else {
			errorCountMessage = "?";
			warningCountMessage = "?";
		}
		
		// Update the UI
		_syntaxErrorTitle.setText(NLS.bind(ProbekitMessages._131,new Object[]{errorCountMessage, warningCountMessage}));
		_syntaxErrorTitle.pack(true);
		_syntaxErrors.setInput(getJDTProblems());
		_syntaxErrors.refresh();
	}
	
	/**
	 * Check the Java syntax of this snippet.
	 * 
	 *  A word about error reporting and markers: this function catches a variety
	 *  of exceptions and reports (some of) them by creating markers of type
	 *  IProbeCompiler.PROBEKIT_PROBLEM_MARKER on the resource in question.
	 *  
	 *  This code doesn't drop a marker on the resource when it catches 
	 *  ProbekitCompileProblemException, because when the probe compiler throws 
	 *  that exception it has already recorded markers to report the details.
	 *  (This happens when there are semantic errors in the probe source, like
	 *  two fragments of the same type.)
	 *  
	 *  You might expect this code to remove markers before it runs, so there
	 *  aren't any stale markers lying around from previous attempts.
	 *  In this case it's not necessary because the probe compiler will remove all
	 *  Probekit markers from the resource as its first action.
	 */

	private void checkSyntax() {
		try {
			_snippet.compile();
			_hasSyntaxBeenChecked = true;
			refreshSyntaxErrorMessage();
		}
		catch (ProbekitCompileProblemException exc) {
			// Do nothing. The probe compiler reported the details as markers already.
		}
		catch (ProbekitException exc) {
			// For all other exceptions, report them using a marker.
			// ProbekitException - a severe internal error thrown by the probe compiler.
			reportCheckSyntaxfailure(exc);
		}
		catch (CoreException exc) {
			// For all other exceptions, report them using a marker.
			// JavaModelException might be thrown, but it is a CoreException so we can handle it here. 
			// Other CoreExceptions are always possible...
			reportCheckSyntaxfailure(exc);
		}
		selectionViewer.refresh();
		detailsViewer.refresh();
	}

	/**
	 * This function is called by checkSyntax from multiple catch clauses.
	 * It reports a failure using a marker with text drawn from
	 * the exception object. If it can't create a marker (a very unlikely event)
	 * it uses a modal dialog. It also marks the editor as not having been checked.
	 * 
	 * @param exc The exception whose message should be used in the marker
	 */
	private void reportCheckSyntaxfailure(Exception exc) {
		_hasSyntaxBeenChecked = false;
		ProbekitUIPlugin.getPlugin().log(exc);
		try {
			IMarker marker = _snippet.getProbeFile().createMarker(IProbeCompiler.PROBEKIT_PROBLEM_MARKER);
			String msg = exc.getLocalizedMessage();
			marker.setAttribute(IMarker.MESSAGE, msg);
			marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_ERROR);
		} catch (CoreException e) {
			// Can't even create a marker? Give up and use a modal dialog.
			MessageDialog.openError(getContainer().getShell(), ProbekitMessages._132,
					NLS.bind(ProbekitMessages._133, exc.getLocalizedMessage()));
		}
	}
			
	protected void createProbeTree(SashForm sf, List probes) {
		ViewerPane sashPane = new ViewerPane(getSite().getPage(), ProbekitEditor.this) {
			public Viewer createViewer(Composite composite) {
				Tree tree = widgetFactory.createTree(composite, SWT.MULTI);
				TreeViewer newTreeViewer = new TreeViewer(tree);
				PlatformUI.getWorkbench().getHelpSystem().setHelp(composite, ContextIds.PROBEKIT_TREEVIEW);
				return newTreeViewer;
			}
			public void requestActivation() {
				if(isActivating) {
					return;
				}
				isActivating = true;
				setCurrentViewerPane(this);
				((ProbekitActionBarContributor) ((IEditorSite) getSite()).getActionBarContributor()).resetGlobalActions(getActionBars());
				//						actionHandlerListener.disableActions();
				this.setFocus();
				isActivating = false;	
			}
		};
		sashPane.createControl(sf);
		selectionViewer = (TreeViewer) sashPane.getViewer();
		selectionViewer.setContentProvider(new ProbekitContentProvider(new AdapterFactoryContentProvider(adapterFactory)));
		selectionViewer.setLabelProvider(new AdapterFactoryLabelProvider(adapterFactory));
		selectionViewer.setInput(getProbekit());
		Image image = ExtendedImageRegistry.getInstance().getImage(getResourceLocator().getImage("full/obj16/Probekit"));
		sashPane.setTitle(ProbekitUIPlugin.getPlugin().getString("4"), image);
		new AdapterFactoryTreeEditor(selectionViewer.getTree(), adapterFactory);

		createContextMenuFor(selectionViewer);
		setCurrentViewerPane(sashPane);
	}
	
	protected void createDetails(SashForm sf) {
		ViewerPane detailsPane = new ViewerPane(getSite().getPage(), ProbekitEditor.this) {
			public Viewer createViewer(Composite composite) {
				ProbekitDetailsViewer detViewer = new ProbekitDetailsViewer(composite, itemProviderFactory, widgetFactory);
				PlatformUI.getWorkbench().getHelpSystem().setHelp(composite, ContextIds.PROBEKIT_DETAILVIEW);
				return detViewer;
			}
			public void requestActivation() {
				if(isActivating) {
					return;
				}
				isActivating = true;
				setCurrentViewerPane(this);
				((ProbekitActionBarContributor) getActionBarContributor()).replaceGlobalActions(getActionBars(),actionHandlerListener);
				isActivating = false;
			}
		};
		detailsPane.createControl(sf);
		detailsViewer = (ProbekitDetailsViewer) detailsPane.getViewer();
		addSelectionChangedListener(detailsViewer);
		selectionViewer.getControl().setRedraw(false);
		selectionViewer.expandToLevel(-1);
		if (selectionViewer.getExpandedElements().length > 0) {
			selectionViewer.setSelection(new StructuredSelection(selectionViewer.getExpandedElements()[0]), true);
		}
		selectionViewer.getControl().setRedraw(true);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setCurrentViewerPane(ViewerPane viewerPane) {
		if (currentViewerPane != viewerPane) {
			if (currentViewerPane != null) {
				currentViewerPane.showFocus(false);
			}
			currentViewerPane = viewerPane;
			currentViewerPane.showFocus(true);
		}
		setCurrentViewer(currentViewerPane.getViewer());
	}
	
	public void setActivePage(Composite composite) {
		if(composite == _generalTab) {
			setActivePage(_generalTabIndex);
		}
		else if(composite == _probesTab) {
			setActivePage(_probesTabIndex);
		}
	}
	
	/**
	 * This makes sure that one content viewer, either for the current page or
	 * the outline view, if it has focus, is the current one. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setCurrentViewer(Viewer viewer) {
		// If it is changing...
		//
		if (currentViewer != viewer) {
			if (selectionChangedListener == null) {
				// Create the listener on demand.
				//
				selectionChangedListener = new ISelectionChangedListener() {
					// This just notifies those things that are affected by the
					// section.
					//
					public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
						setSelection(selectionChangedEvent.getSelection());
					}
				};
			}
			// Stop listening to the old one.
			//
			if (currentViewer != null) {
				currentViewer.removeSelectionChangedListener(selectionChangedListener);
			}
			// Start listening to the new one.
			//
			if (viewer != null) {
				viewer.addSelectionChangedListener(selectionChangedListener);
			}
			// Remember it.
			//
			currentViewer = viewer;
			// Set the editors selection based on the current viewer's
			// selection.
			//
			setSelection(currentViewer == null ? StructuredSelection.EMPTY : currentViewer.getSelection());
		}
	}

	/**
	 * This returns the viewer as required by the {@link IViewerProvider}
	 * interface. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Viewer getViewer() {
		return currentViewer;
	}

	/**
	 * This sets the selection into whichever viewer is active. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setSelectionToViewer(Collection collection) {
		final Collection theSelection = collection;
		// Make sure it's okay.
		//
		if (theSelection != null && !theSelection.isEmpty()) {
			// I don't know if this should be run this deferred
			// because we might have to give the editor a chance to process the
			// viewer update events
			// and hence to update the views first.
			//
			//
			Runnable runnable = new Runnable() {
				public void run() {
					// Try to select the items in the current content viewer of
					// the editor.
					//
					if (currentViewer != null) {
						currentViewer.setSelection(new StructuredSelection(theSelection.toArray()), true);
					}
				}
			};
			runnable.run();
		}
	}

	private void select(IProblem problem) {
		EObject eObject = _snippet.getEObject(problem);
		if(eObject != null) {
			
			Object eTreeObject = eObject;
			
			if(eObject instanceof DataItem)
			{
				eTreeObject = ((DataItem)eObject).eContainer();
			}
			
			else if( EObjectListSwitch.isSwitchForFeature(eObject.eContainingFeature()) ) {
				Probe probe = (Probe)eObject.eContainer();
				eTreeObject = probe.eGet(eObject.eContainingFeature());
			}
			// update the probe TreeViewer; it doesn't necessarily fire a selection event
			// in the underlying tree widget (at least in gdk)
			selectionViewer.setSelection(new StructuredSelection(eTreeObject));
			// fire the change - update the details
			setSelection(new StructuredSelection(eObject));
		}
	}
	
	/**
	 * @param resourceSet
	 * @return
	 */
	private Object getInput() {
		ResourceSet resourceSet = editingDomain.getResourceSet();
		if (resourceSet != null && resourceSet.getResources().size() > 0) {
			List resources = resourceSet.getResources();
			Object selected = null;
			for (Iterator iter = resources.iterator(); iter.hasNext();) {
				Resource element = (Resource) iter.next();
				if (element.getURI().fileExtension().equals("probe")) {
					try {
						EObject rootObject = (EObject) element.getContents().get(0);
						selected = rootObject;
						break;
					} catch (Throwable e) {
						if (e instanceof org.xml.sax.SAXParseException) {
							selected = addProbekitElement(element);
						} else
							ProbekitUIPlugin.INSTANCE.log(e);
					}
				}
			}
			return selected;
		} else
			return resourceSet;
	}
	
	private Probekit getProbekit() {
		ResourceSet resourceSet = editingDomain.getResourceSet();
		if (resourceSet != null && resourceSet.getResources().size() > 0) {
			Iterator iterator = resourceSet.getAllContents();
			while(iterator.hasNext()) {
				Object next = iterator.next();
				if(next instanceof Probekit) {
					return (Probekit)next;
				}
			}
		}
		return null;
	}
	
	private List getProbes() {
		ResourceSet resourceSet = editingDomain.getResourceSet();
		List probes = new ArrayList();
		if (resourceSet != null && resourceSet.getResources().size() > 0) {
			Iterator iterator = resourceSet.getAllContents();
			while(iterator.hasNext()) {
				Object next = iterator.next();
				if(next instanceof Probe) {
					probes.add(next);
				}
			}
		}
		return probes;
	}
	
	private List getJDTProblems() {
		return _jdtProblems;
	}
	
	// TTT end added
	/**
	 * @param element
	 * @return
	 */
	private Object addProbekitElement(Resource element) {
		Object selected;
		DocumentRoot documentRoot = ProbekitFactory.eINSTANCE.createDocumentRoot();
		Probekit probekit = ProbekitFactory.eINSTANCE.createProbekit();
		documentRoot.setProbekit(probekit);
		element.getContents().add(documentRoot);
		selected = documentRoot;
		return selected;
	}

	/**
	 * This is used to track the active viewer. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected void pageChange(int pageIndex) {
		super.pageChange(pageIndex);
		// This is a temporary workaround... EATM
		//
		Control control = getControl(pageIndex);
		if (control != null) {
			control.setVisible(true);
			control.setFocus();
		}
	}
	/**
	 * This is how the framework determines which interfaces we implement. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Object getAdapter(Class key) {
		if (key.equals(IPropertySheetPage.class)) {
			return getPropertySheetPage();
		} else {
			return super.getAdapter(key);
		}
	}
	/**
	 * This accesses a cached version of the property sheet. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public IPropertySheetPage getPropertySheetPage() {
		if (propertySheetPage == null) {
			propertySheetPage = new PropertySheetPage() {
				public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
					super.makeContributions(menuManager, toolBarManager, statusLineManager);
				}
				public void setActionBars(IActionBars actionBars) {
					super.setActionBars(actionBars);
					getActionBarContributor().shareGlobalActions(this, actionBars);
				}
			};
			propertySheetPage.setPropertySourceProvider(new AdapterFactoryContentProvider(adapterFactory));
		}
		return propertySheetPage;
	}
	/**
	 * This deals with how we want selection in the outliner to affect the other
	 * views. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void handleContentOutlineSelection(ISelection selection) {
		if (currentViewerPane != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
			Iterator selectedElements = ((IStructuredSelection) selection).iterator();
			if (selectedElements.hasNext()) {
				// Get the first selected element.
				//
				Object selectedElement = selectedElements.next();
				
				if(_generalTab.isPageFor(selectedElement)) {
					setActivePage(_generalTab);
				}
				else {
					setActivePage(_probesTab);
				}
				// If it's the selection viewer, then we want it to select the
				// same selection as this selection.
				//
				if (currentViewerPane.getViewer() == selectionViewer) {
					ArrayList selectionList = new ArrayList();
					selectionList.add(selectedElement);
					while (selectedElements.hasNext()) {
						selectionList.add(selectedElements.next());
					}
					// Set the selection to the widget.
					//
					selectionViewer.setSelection(new StructuredSelection(selectionList));
					// Set the input to the widget.
					//
				} else {
					// Set the input to the widget.
					//
					if (currentViewerPane.getViewer().getInput() != selectedElement) {
						currentViewerPane.getViewer().setInput(selectedElement);
						currentViewerPane.setTitle(selectedElement);
					}
				}
			}
		}
	}
	/**
	 * This is for implementing {@link IEditorPart}and simply tests the command
	 * stack. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public boolean isDirty() {
		return ((BasicCommandStack) editingDomain.getCommandStack()).isSaveNeeded();
	}
	/**
	 * This is for implementing {@link IEditorPart}and simply saves the model
	 * file. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public void doSave(IProgressMonitor progressMonitor) {
		// Do the work within an operation because this is a long running
		// activity that modifies the workbench.
		//
		WorkspaceModifyOperation operation = new WorkspaceModifyOperation() {
			// This is the method that gets invoked when the operation runs.
			//
			protected void execute(IProgressMonitor monitor) throws CoreException {
				try {
					// Save the resource to the file system.
					//
					Resource savedResource = (Resource) editingDomain.getResourceSet().getResources().get(0);
					savedResources.add(savedResource);
					savedResource.save(Collections.EMPTY_MAP);
				} catch (Exception exception) {
					ProbekitUIPlugin.INSTANCE.log(exception);
				}
				
				checkSyntax();
			}
		};
		try {
			// This runs the options, and shows progress.
			// (It appears to be a bad thing to fork this onto another thread.)
			//
			new ProgressMonitorDialog(getSite().getShell()).run(false, false, operation);
			// Refresh the necessary state.
			//
			((BasicCommandStack) editingDomain.getCommandStack()).saveIsDone();
			firePropertyChange(IEditorPart.PROP_DIRTY);
		} catch (Exception exception) {
			// Something went wrong that shouldn't.
			//
			ProbekitUIPlugin.INSTANCE.log(exception);
		}
	}
	
	/**
	 * This always returns true because it is not currently supported. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public boolean isSaveAsAllowed() {
		return true;
	}
	
	/**
	 * This also changes the editor's input. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public void doSaveAs() {
		SaveAsDialog saveAsDialog = new SaveAsDialog(getSite().getShell());
		saveAsDialog.open();
		IPath path = saveAsDialog.getResult();
		if (path != null) {
			IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
			if (file != null) {
				((Resource) editingDomain.getResourceSet().getResources().get(0)).setURI(URI.createPlatformResourceURI(file.getFullPath().toString()));
				IFileEditorInput modelFile = new FileEditorInput(file);
				setInput(modelFile);
				setPartName(file.getFullPath().toString()); // Title
				doSave(getActionBars().getStatusLineManager().getProgressMonitor());
			}
		}
	}
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void gotoMarker(IMarker marker) {
	}
	/**
	 * This is called during startup. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @generated
	 */
	public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
		if (editorInput instanceof IFileEditorInput) {
			setSite(site);
			setInput(editorInput);
			IFileEditorInput fe = (IFileEditorInput)editorInput;
			setPartName(fe.getFile().getName()); // Title
			site.setSelectionProvider(this);
			site.getPage().addPartListener(partListener);
			ResourcesPlugin.getWorkspace().addResourceChangeListener(this);
			//			actionHandlerListener.connectPart(this);
		} else {
			throw new PartInitException("Invalid Input: Must be IFileEditorInput.");
		}
		
		file = ((IFileEditorInput)editorInput).getFile();
		
	}
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setFocus() {
		getControl(getActivePage()).setFocus();
	}
	/**
	 * This implements {@link org.eclipse.jface.viewers.ISelectionProvider}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void addSelectionChangedListener(ISelectionChangedListener listener) {
		synchronized (selectionChangedListeners) {
			selectionChangedListeners.add(listener);
		}
	}
	/**
	 * This implements {@link org.eclipse.jface.viewers.ISelectionProvider}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void removeSelectionChangedListener(ISelectionChangedListener listener) {
		synchronized (selectionChangedListeners) {
			selectionChangedListeners.remove(listener);
		}
	}
	/**
	 * This implements {@link org.eclipse.jface.viewers.ISelectionProvider}to
	 * return this editor's overall selection. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public ISelection getSelection() {
		return editorSelection;
	}
	/**
	 * This implements {@link org.eclipse.jface.viewers.ISelectionProvider}to
	 * set this editor's overall selection. Calling this result will notify the
	 * listeners. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public void setSelection(ISelection selection) {
		editorSelection = selection;
		if (selection == null)
			return;
		Exception e1 = null;
		try {
			synchronized (selectionChangedListeners) {
				ISelectionChangedListener[] changedListeners = (ISelectionChangedListener[]) selectionChangedListeners.toArray(new ISelectionChangedListener[selectionChangedListeners.size()]);
				for (int i = 0; i < changedListeners.length; i++) {
					ISelectionChangedListener listener = changedListeners[i];
					listener.selectionChanged(new SelectionChangedEvent(this, selection));
				}
			}
		} catch (ConcurrentModificationException e) {
			e1 = e;
		}
		if (e1 != null) {
			ProbekitUIPlugin.getPlugin().log(e1);
		}
		setStatusLineManager(selection);
	}
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setStatusLineManager(ISelection selection) {
		IStatusLineManager statusLineManager = getActionBars().getStatusLineManager();
		if (currentViewer == contentOutlineViewer) {
			statusLineManager = contentOutlineStatusLineManager;
		}
		if (selection instanceof IStructuredSelection) {
			Collection collection = ((IStructuredSelection) selection).toList();
			switch (collection.size()) {
				case 0 : {
					statusLineManager.setMessage(ProbekitMessages._6);
					break;
				}
				case 1 : {
					String text = new AdapterFactoryItemDelegator(adapterFactory).getText(collection.iterator().next());
					statusLineManager.setMessage(NLS.bind(ProbekitMessages._5, text));					
					break;
				}
				default : {
					statusLineManager.setMessage(NLS.bind(ProbekitMessages._7, Integer.toString(collection.size())));
					break;
				}
			}
		} else {
			statusLineManager.setMessage("");
		}
	}
	/**
	 * This implements {@link org.eclipse.jface.action.IMenuListener}to help
	 * fill the context menus with contributions from the Edit menu. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void menuAboutToShow(IMenuManager menuManager) {
		((IMenuListener) getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
	}
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EditingDomainActionBarContributor getActionBarContributor() {
		return (EditingDomainActionBarContributor) getEditorSite().getActionBarContributor();
	}
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public IActionBars getActionBars() {
		return getActionBarContributor().getActionBars();
	}
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public AdapterFactory getAdapterFactory() {
		return adapterFactory;
	}
	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void dispose() {
		ResourcesPlugin.getWorkspace().removeResourceChangeListener(this);
		getSite().getPage().removePartListener(partListener);
		adapterFactory.dispose();
		getActionBarContributor().setActiveEditor(null);
		if (propertySheetPage != null) {
			propertySheetPage.dispose();
		}
		if (detailsViewer != null) {
			detailsViewer.dispose();
		}
		
		_generalTab.dispose();
		try {
			_snippet.release();
		}
		catch(JavaModelException exc) {
			// Closing the editor anyway, so just log the exception.
			ProbekitUIPlugin.getPlugin().log(exc);
		}
		
		file = null;
		super.dispose();
	}
	/**
	 * @return
	 */
	public ProbekitItemProviderAdapterFactory getItemProviderFactory() {
		return itemProviderFactory;
	}
	
  	public boolean visit(IResourceDelta delta)
  	{
  		if(delta.getKind()==IResourceDelta.REMOVED && delta.getResource().equals(file)){
  			
			getSite().getShell().getDisplay().asyncExec
			(new Runnable() {
			 	public void run() {
					getSite().getPage().closeEditor(ProbekitEditor.this, false);
					ProbekitEditor.this.dispose();
			 	}
			 });
  			
		}
  		return true;
  }

	public void resourceChanged(IResourceChangeEvent event){
		IResourceDelta delta = event.getDelta();
		IResourceDelta iFile_delta;
		
		
	    try
	    {
	      if (delta != null && (iFile_delta = delta.findMember(file.getFullPath()))!=null) 
	      {
			iFile_delta.accept(this);
	      }
	    }
	    catch (Exception e)
	    {      
		   e.printStackTrace();
	    }      
	}
	
	public void addProbe() {
		
		Probekit probekit = getProbekit();
		Probe probe = ProbekitFactory.eINSTANCE.createProbe();
		CreateChildCommand command = new CreateChildCommand(editingDomain, probekit, ProbekitPackage.eINSTANCE.getProbekit_Probe(), probe, Collections.EMPTY_LIST);
		editingDomain.getCommandStack().execute(command);
		setSelection(new StructuredSelection(probe));
		
		if(selectionViewer != null) {
			selectionViewer.setExpandedState(probe, true); 
		}											
	}
	
}