/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StaticFieldDetails.java,v 1.3 2008/05/29 21:14:11 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit.editor.internal.presentation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.models.internal.probekit.StaticField;
import org.eclipse.hyades.models.internal.probekit.impl.StaticFieldImpl;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.hyades.probekit.editor.internal.provider.StaticFieldItemProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class StaticFieldDetails extends BaseDetails implements ModifyListener {
	protected final EAttribute TYPE = ProbekitPackage.eINSTANCE.getStaticField_Type(); 
	//	protected final String VALUE = "Value";
	protected Text type;
	//	protected Text value;
	protected boolean isDisplaying;
	protected StaticField currentSelection;
	protected StaticFieldItemProvider itemProvider;
	protected ProbekitItemProviderAdapterFactory itemFactory;
	public StaticFieldDetails(ProbekitWidgetFactory factory, ProbekitItemProviderAdapterFactory itemFactory, Composite composite, int style) {
		super(composite, style);
		this.itemFactory = itemFactory;
		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 1;
		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
		factory.createLabel(this, ProbekitMessages._29, SWT.NONE);
		type = factory.createText(this, "", SWT.NULL);
		type.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		// language.setData(new Integer(0));
		//		label = factory.createLabel(this,
		// ProbekitMessages._30, SWT.NONE);
		//		value = factory.createText(this, "", SWT.NONE);
		//		value.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		// name.setData(new Integer(0));
		// add listeners - don't change the order in which the listeners are
		// added
		// because of team support issues modify listeners should always be the
		// last one added
		type.addModifyListener(this);
		//		value.addModifyListener(this);
		itemProvider = (StaticFieldItemProvider) itemFactory.createStaticFieldAdapter();
		
		addFocusListenerTo(type);

	}
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(Object object) {
		if (type.isFocusControl()) {
			return;
		}
		currentSelection = (StaticField) object;
		isDisplaying = true;
		type.setText(currentSelection.getType() == null ? "" : currentSelection.getType());
		//		value.setText(
		//			currentSelection.getValue() == null
		//				? ""
		//				: currentSelection.getValue());
		isDisplaying = false;
		setFocusTo();
	}
	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(Object currentSelection) {
		this.currentSelection = (StaticField) currentSelection;
		this.currentSelection.setType(type.getText().trim());
		//		this.currentSelection.setValue(value.getText().trim());
		return false;
	}
	public void setFocusToText() {
		type.setFocus();
		type.selectAll();
	}
	/**
	 * Sent when the text is modified.
	 * 
	 * @param e
	 *            an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e) {
		if (currentSelection == null)
			return;
		if (e.getSource() == type) {
			String text = type.getText().trim();
			if (!text.equals(currentSelection.getType())) {
				if (text.length() == 0 && currentSelection.getType() == null)
					return;
				IItemPropertyDescriptor descriptor = itemProvider.getPropertyDescriptor(currentSelection, TYPE);
				if (descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);
			}
		}
		//		else if (e.getSource() == value) {
		//			String text = value.getText().trim();
		//			if (!text.equals(currentSelection.getValue())) {
		//				if (text.length() == 0 && currentSelection.getValue() == null)
		//					return;
		//
		//				IItemPropertyDescriptor descriptor =
		//					itemProvider.getPropertyDescriptor(
		//						currentSelection,
		//						VALUE);
		//
		//				if (descriptor != null)
		//					descriptor.setPropertyValue(currentSelection, text);
		//			}
		//
		//		}
	}
	public void dispose() {
		itemFactory = null;
		itemProvider = null;
		type = null;
		//		value = null;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.probekit.internal.presentation.IDetails#isDetailsFor(java.lang.Object)
	 */
	public boolean isDetailsFor(Object object) {
		if (object instanceof StaticField || object instanceof StaticFieldImpl) {
			return true;
		}
		return false;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.probekit.internal.presentation.IDetails#setFocusTo()
	 */
	public void setFocusTo() {
		setFocusToText();
	}

	public void refresh() {
	}
}