/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TargetDetails.java,v 1.5 2008/05/29 21:14:11 jkubasta Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit.editor.internal.presentation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.models.internal.probekit.Target;
import org.eclipse.hyades.models.internal.probekit.impl.TargetImpl;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.provider.ProbekitItemProviderAdapterFactory;
import org.eclipse.hyades.probekit.editor.internal.provider.TargetItemProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class TargetDetails extends BaseDetails implements ModifyListener {
	protected final EAttribute TYPE = ProbekitPackage.eINSTANCE.getTarget_Type();
	protected final EAttribute PACKAGE = ProbekitPackage.eINSTANCE.getTarget_Package();
	protected final EAttribute CLASSNAME = ProbekitPackage.eINSTANCE.getTarget_ClassName();
	protected final EAttribute METHOD = ProbekitPackage.eINSTANCE.getTarget_Method();
	protected final EAttribute SIGNATURE = ProbekitPackage.eINSTANCE.getTarget_Signature();
	protected CCombo typeCombo;
	protected Text packageText;
	protected Text classText;
	protected Text methodText;
	protected Text signatureText;
	protected boolean isDisplaying;
	protected Target currentSelection;
	protected TargetItemProvider itemProvider;
	protected ProbekitItemProviderAdapterFactory itemFactory;
	public TargetDetails(ProbekitWidgetFactory factory, ProbekitItemProviderAdapterFactory itemFactory, Composite composite, int style) {
		super(composite, style);
		this.itemFactory = itemFactory;
		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 1;
		this.setLayout(detailLayout);
		GridData data = GridUtil.createFill();
		data.widthHint = 300;
		this.setLayoutData(data);
		
		Label typeLabel = factory.createLabel(this, ProbekitMessages._22, SWT.NONE);
		typeLabel.setBackground(this.getBackground());
		typeCombo = factory.createCombo(this, SWT.BORDER);
		typeCombo.setItems(
				new String[] {
						TargetTypeEnum.INCLUDE.getTranslatedType(),
						TargetTypeEnum.EXCLUDE.getTranslatedType()
				}
		);
		typeCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		Label packageLabel = factory.createLabel(this, ProbekitMessages._25, SWT.NONE);
		packageLabel.setBackground(this.getBackground());
		packageText = factory.createText(this, "", SWT.BORDER);
		packageText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Label classLabel = factory.createLabel(this, ProbekitMessages._26, SWT.NONE);
		classLabel.setBackground(this.getBackground());
		classText = factory.createText(this, "", SWT.BORDER);
		classText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Label methodLabel = factory.createLabel(this, ProbekitMessages._27, SWT.NONE);
		methodLabel.setBackground(this.getBackground());
		methodText = factory.createText(this, "", SWT.BORDER);
		methodText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Label signatureLabel = factory.createLabel(this, ProbekitMessages._28, SWT.NONE);
		signatureLabel.setBackground(this.getBackground());
		signatureText = factory.createText(this, "", SWT.BORDER);
		signatureText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		// signatureText.setData(new Integer(0));
		// add listeners - don't change the order in which the listeners are
		// added
		// because of team support issues modify listeners should always be the
		// last one added
		typeCombo.addModifyListener(this);
		packageText.addModifyListener(this);
		classText.addModifyListener(this);
		methodText.addModifyListener(this);
		signatureText.addModifyListener(this);
		itemProvider = (TargetItemProvider) itemFactory.createTargetAdapter();
		
		addFocusListenerTo(typeCombo);
		addFocusListenerTo(packageText);
		addFocusListenerTo(classText);
		addFocusListenerTo(methodText);
		addFocusListenerTo(signatureText);

	}
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(Object object) {
		if (typeCombo.isFocusControl() || packageText.isFocusControl() || classText.isFocusControl() || methodText.isFocusControl() || signatureText.isFocusControl())
			return;
		currentSelection = (Target) object;
		isDisplaying = true;
		typeCombo.setText(currentSelection.getType() == null ? "" : currentSelection.getType());
		packageText.setText(currentSelection.getPackage() == null ? "" : currentSelection.getPackage());
		classText.setText(currentSelection.getClassName() == null ? "" : currentSelection.getClassName());
		methodText.setText(currentSelection.getMethod() == null ? "" : currentSelection.getMethod());
		signatureText.setText(currentSelection.getSignature() == null ? "" : currentSelection.getSignature());
		isDisplaying = false;
	}
	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(Object currentSelection) {
		this.currentSelection = (Target) currentSelection;
		this.currentSelection.setType(typeCombo.getText().trim());
		this.currentSelection.setPackage(packageText.getText().trim());
		this.currentSelection.setClassName(classText.getText().trim());
		this.currentSelection.setMethod(methodText.getText().trim());
		this.currentSelection.setSignature(signatureText.getText().trim());
		return false;
	}
	public void setFocusToType() {
		typeCombo.setFocus();
	}
	/**
	 * Sent when the text is modified.
	 * 
	 * @param e
	 *            an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e) {
		if (currentSelection == null)
			return;
		if (e.getSource() == typeCombo) {
			String text = typeCombo.getText().trim();
			if (!text.equals(currentSelection.getType())) {
				if (text.length() == 0 && currentSelection.getType() == null)
					return;
				IItemPropertyDescriptor descriptor = itemProvider.getPropertyDescriptor(currentSelection, TYPE);
				if (descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);
			}
		} else if (e.getSource() == packageText) {
			String text = packageText.getText().trim();
			if (!text.equals(currentSelection.getPackage())) {
				if (text.length() == 0 && currentSelection.getPackage() == null)
					return;
				IItemPropertyDescriptor descriptor = itemProvider.getPropertyDescriptor(currentSelection, PACKAGE);
				if (descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);
			}
		} else if (e.getSource() == classText) {
			String text = classText.getText().trim();
			if (!text.equals(currentSelection.getClassName())) {
				if (text.length() == 0 && currentSelection.getClassName() == null)
					return;
				IItemPropertyDescriptor descriptor = itemProvider.getPropertyDescriptor(currentSelection, CLASSNAME);
				if (descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);
			}
		} else if (e.getSource() == methodText) {
			String text = methodText.getText().trim();
			if (!text.equals(currentSelection.getMethod())) {
				if (text.length() == 0 && currentSelection.getMethod() == null)
					return;
				IItemPropertyDescriptor descriptor = itemProvider.getPropertyDescriptor(currentSelection, METHOD);
				if (descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);
			}
		} else if (e.getSource() == signatureText) {
			String text = signatureText.getText().trim();
			if (!text.equals(currentSelection.getSignature())) {
				if (text.length() == 0 && currentSelection.getSignature() == null)
					return;
				IItemPropertyDescriptor descriptor = itemProvider.getPropertyDescriptor(currentSelection, SIGNATURE);
				if (descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);
			}
		}
	}
	public void dispose() {
		itemFactory = null;
		itemProvider = null;
		typeCombo = null;
		packageText = null;
		classText = null;
		methodText = null;
		signatureText = null;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.probekit.internal.presentation.IDetails#isDetailsFor(java.lang.Object)
	 */
	public boolean isDetailsFor(Object object) {
		if (object instanceof Target || object instanceof TargetImpl) {
			return true;
		}
		return false;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.models.probekit.internal.presentation.IDetails#setFocusTo()
	 */
	public void setFocusTo() {
		setFocusToType();
	}

	public void refresh() {
	}
}