/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TargetTypeEnum.java,v 1.2 2005/12/30 02:58:09 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.hyades.probekit.editor.internal.presentation;

import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;

public class TargetTypeEnum {
	private final String _type;
	private final String _translatedType;
	
	private TargetTypeEnum(String type, String translatedType) {
		_type = type;
		_translatedType = translatedType;
	}
	
	public String getType() {
		return _type;
	}
	
	public String getTranslatedType() {
		return _translatedType;
	}
	
	public static TargetTypeEnum getTargetType(String typeName) {
		for(int i=0; i<ALL.length; i++) {
			TargetTypeEnum enumeration = ALL[i];
			if(enumeration.getTranslatedType().equals(typeName)) {
				return enumeration;
			}
		}
		return UNSET;
	}	
	
	public static final TargetTypeEnum INCLUDE = new TargetTypeEnum("include", ProbekitMessages._126); //$NON-NLS-1$ 
	public static final TargetTypeEnum EXCLUDE = new TargetTypeEnum("exclude", ProbekitMessages._127); //$NON-NLS-1$ 
	public static final TargetTypeEnum UNSET = new TargetTypeEnum("", ""); //$NON-NLS-1$ //$NON-NLS-2$
	private static final TargetTypeEnum[] ALL = 
		new TargetTypeEnum[] {
			INCLUDE,
			EXCLUDE
		};
}
