/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AlphabeticalComparator.java,v 1.1 2005/06/07 04:04:15 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.hyades.probekit.editor.internal.presentation.codeassist;

import java.util.Comparator;

import org.eclipse.jface.text.contentassist.ICompletionProposal;


class AlphabeticalComparator implements Comparator {
	public static final AlphabeticalComparator INSTANCE = new AlphabeticalComparator();
	
	private AlphabeticalComparator() {
	}
	
	public int compare(Object a, Object b) {
		if((a == null) && (b == null)) {
			return 0;
		}
		else if(a == null) {
			return 1;
		}
		else if(b == null) {
			return -1;
		}
		
		ICompletionProposal aProposal = (ICompletionProposal)a;
		ICompletionProposal bProposal = (ICompletionProposal)b;
		return aProposal.getDisplayString().compareTo(bProposal.getDisplayString());
	}
}