/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SyntaxAdapter.java,v 1.1 2005/06/07 04:04:15 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.hyades.probekit.editor.internal.presentation.codeassist;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.compiler.IProblem;


public class SyntaxAdapter extends AdapterImpl {
	private List _jdtCompileProblems;
	private int _errorCount;
	private int _warningCount;
	
	public SyntaxAdapter() {
		_jdtCompileProblems = new ArrayList();
		_errorCount = 0;
		_warningCount = 0;
	}

	public IProblem[] getKnownProblems() {
		return (IProblem[])getProblems().toArray(new IProblem[_jdtCompileProblems.size()]);
	}
	
	protected List getProblems() {
		return _jdtCompileProblems;
	}

	public void addProblem(IProblem problem) {
		getProblems().add(problem);
		if(problem.isError()) {
			_errorCount++;
		}
		else if(problem.isWarning()) {
			_warningCount++;
		}
	}

	public void clearProblems() {
		getProblems().clear();
		_errorCount = 0;
		_warningCount = 0;
	}
	
	public int errorCount() {
		return _errorCount;
	}
	
	public int warningCount() {
		return _warningCount;
	}
	
	public boolean containsErrors() {
		return (_errorCount > 0);
	}
	
	public boolean containsWarnings() {
		return (_warningCount > 0);
	}

	public boolean isAdapterForType(Object type) {
		if(type instanceof EObject) {
			return true;
		}
		return false;
	}

	public String toString() {
		return "errors: " + errorCount() + ", warnings: " + warningCount();
	}
}
