/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AllImportsItemProvider.java,v 1.2 2005/12/30 02:58:11 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.hyades.probekit.editor.internal.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.hyades.models.internal.probekit.Import;
import org.eclipse.hyades.models.internal.probekit.Probe;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.probekit.editor.internal.core.util.MessageConstants;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.presentation.codeassist.JavaSnippet;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;



public class AllImportsItemProvider 
				extends EObjectListItemProvider 
				implements 	IItemLabelProvider, 
							IStructuredItemContentProvider,
							ITreeItemContentProvider,
							IEditingDomainItemProvider, 
							IItemPropertySource {
	public AllImportsItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	public String getText(Object object) {
		return ProbekitMessages._123;
	}

	/**
	 * This returns Import.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		Object image = JavaSnippet.getImageURL(object);
		if(image != null) {
			return image;
		}
		return ProbekitUIPlugin.INSTANCE.getImage("full/obj16/Import");
	}
	
	public Collection getChildren(Object object) {
		return Collections.EMPTY_LIST;
	}

	public Collection getNewChildDescriptors(Object object,
			EditingDomain editingDomain, Object sibling) {
		return Collections.EMPTY_LIST;
	}

	protected void addTextPropertyDescriptor(EObjectContainmentEList list) {
		itemPropertyDescriptors.add(
			new EObjectListItemPropertyDescriptor
			(
				((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				getString(MessageConstants._UI_Properties_EList_Attribute),
				getString(MessageConstants._UI_Properties_EList_Description, new String[]{list.getEStructuralFeature().getName()}),
				 list.getEStructuralFeature(),
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE
			)
		);
	}
	
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			EObjectContainmentEList list = (EObjectContainmentEList)object;
			addTextPropertyDescriptor(list);
		}
		return itemPropertyDescriptors;
	}

	public ResourceLocator getResourceLocator() {
		return ProbekitUIPlugin.INSTANCE;
	}

	/**
	 * When an import is added on the AllImportsDetails, a CreateChild command 
	 * should be added to the editor's stack so that it can be done, 
	 * undone, and the Viewer is marked dirty.
	 */
	public void addAndNotify(Probe probe, Import affectedImport) {
		EditingDomain domain = findEditingDomain(probe);
		if(domain != null) {
			CreateChildCommand command = new CreateChildCommand(domain, probe, ProbekitPackage.eINSTANCE.getProbe_Import(), affectedImport, Collections.EMPTY_LIST);
			executeCommand(domain, command);
		}
	}
	
	/**
	 * When an import is removed on the AllImportsDetails, a Remove command 
	 * should be added to the editor's stack so that it can be done, 
	 * undone, and the Viewer is marked dirty.
	 */
	public void removeAndNotify(Probe probe, Import affectedImport) {
		EditingDomain domain = findEditingDomain(probe);
		if(domain != null) {
			RemoveCommand command = new RemoveCommand(domain, probe, ProbekitPackage.eINSTANCE.getProbe_Import(), affectedImport);
			executeCommand(domain, command);
		}
	}
	
	private EditingDomain findEditingDomain(Probe probe) {
		return AdapterFactoryEditingDomain.getEditingDomainFor(probe);
	}
	
	private void executeCommand(EditingDomain domain, Command command) {
		if((domain != null) && (command != null)) {
		    domain.getCommandStack().execute(command);
		}
	}
	
}
