/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DocumentRootItemProvider.java,v 1.1 2005/06/07 04:04:15 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit.editor.internal.provider;



import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.hyades.models.internal.probekit.DocumentRoot;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;


/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.models.internal.probekit.DocumentRoot} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class DocumentRootItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DocumentRootItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);


			addCodePropertyDescriptor(object);

			addFragmentAtClassScopePropertyDescriptor(object);

		}
		return itemPropertyDescriptors;
	}


	/**
	 * This adds a property descriptor for the Code feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addCodePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("_UI_DocumentRoot_code_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_DocumentRoot_code_feature", "_UI_DocumentRoot_type"),
				 ProbekitPackage.eINSTANCE.getDocumentRoot_Code(),

				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));

	}


	/**
	 * This adds a property descriptor for the Fragment At Class Scope feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addFragmentAtClassScopePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("_UI_DocumentRoot_fragmentAtClassScope_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_DocumentRoot_fragmentAtClassScope_feature", "_UI_DocumentRoot_type"),
				 ProbekitPackage.eINSTANCE.getDocumentRoot_FragmentAtClassScope(),

				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));

	}


	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Collection getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);

			childrenFeatures.add(ProbekitPackage.eINSTANCE.getDocumentRoot_Probekit());
		}
		return childrenFeatures;
	}



	/**
	 * This returns DocumentRoot.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		return getResourceLocator().getImage("full/obj16/DocumentRoot");
	}


	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText(Object object) {
		String label = ((DocumentRoot)object).getCode();

		return label == null || label.length() == 0 ?
			getString("_UI_DocumentRoot_type") :
			getString("_UI_DocumentRoot_type") + " " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		updateChildren(notification);


		switch (notification.getFeatureID(DocumentRoot.class)) {
			case ProbekitPackage.DOCUMENT_ROOT__CODE:

			case ProbekitPackage.DOCUMENT_ROOT__FRAGMENT_AT_CLASS_SCOPE:

				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;

			case ProbekitPackage.DOCUMENT_ROOT__MIXED:

				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;

		}

		super.notifyChanged(notification);
	}


	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

//
//		newChildDescriptors.add
//			(createChildParameter
//				(ProbekitPackage.eINSTANCE.getDocumentRoot_ControlKey(),
//
//				 ProbekitFactory.eINSTANCE.createControlKey()));
//
//
//		newChildDescriptors.add
//			(createChildParameter
//				(ProbekitPackage.eINSTANCE.getDocumentRoot_ControlName(),
//
//				 ProbekitFactory.eINSTANCE.createControlName()));
//
//
//		newChildDescriptors.add
//			(createChildParameter
//				(ProbekitPackage.eINSTANCE.getDocumentRoot_Data(),
//
//				 ProbekitFactory.eINSTANCE.createDataItem()));
//
//
//		newChildDescriptors.add
//			(createChildParameter
//				(ProbekitPackage.eINSTANCE.getDocumentRoot_Description(),
//
//				 ProbekitFactory.eINSTANCE.createDescription()));
//
//
//		newChildDescriptors.add
//			(createChildParameter
//				(ProbekitPackage.eINSTANCE.getDocumentRoot_Fragment(),
//
//				 ProbekitFactory.eINSTANCE.createFragment()));
//
//
//		newChildDescriptors.add
//			(createChildParameter
//				(ProbekitPackage.eINSTANCE.getDocumentRoot_Import(),
//
//				 ProbekitFactory.eINSTANCE.createImport()));
//
//
//		newChildDescriptors.add
//			(createChildParameter
//				(ProbekitPackage.eINSTANCE.getDocumentRoot_InvocationObject(),
//
//				 ProbekitFactory.eINSTANCE.createInvocationObject()));
//
//
//		newChildDescriptors.add
//			(createChildParameter
//				(ProbekitPackage.eINSTANCE.getDocumentRoot_Label(),
//
//				 ProbekitFactory.eINSTANCE.createLabel()));
//
//
//		newChildDescriptors.add
//			(createChildParameter
//				(ProbekitPackage.eINSTANCE.getDocumentRoot_Name(),
//
//				 ProbekitFactory.eINSTANCE.createName()));
//
//
//		newChildDescriptors.add
//			(createChildParameter
//				(ProbekitPackage.eINSTANCE.getDocumentRoot_Probe(),
//
//				 ProbekitFactory.eINSTANCE.createProbe()));
//
//
//		newChildDescriptors.add
//			(createChildParameter
//				(ProbekitPackage.eINSTANCE.getDocumentRoot_Probekit(),
//
//				 ProbekitFactory.eINSTANCE.createProbekit()));
//
//
//		newChildDescriptors.add
//			(createChildParameter
//				(ProbekitPackage.eINSTANCE.getDocumentRoot_StaticField(),
//
//				 ProbekitFactory.eINSTANCE.createStaticField()));
//
//
//		newChildDescriptors.add
//			(createChildParameter
//				(ProbekitPackage.eINSTANCE.getDocumentRoot_Target(),
//
//				 ProbekitFactory.eINSTANCE.createTarget()));

	}


	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return ProbekitUIPlugin.INSTANCE;
	}
}

