/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EObjectListItemPropertyDescriptor.java,v 1.1 2005/06/07 04:04:15 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.hyades.probekit.editor.internal.provider;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;


public class EObjectListItemPropertyDescriptor extends ItemPropertyDescriptor implements IItemPropertyDescriptor {
	public EObjectListItemPropertyDescriptor(
		AdapterFactory adapterFactory,
		String displayName,
		String description,
		EStructuralFeature feature,
		Object staticImage) {
		super(adapterFactory, displayName, description, feature, false, staticImage);
	}
	
	public Object getPropertyValue(Object object) {
		EObjectContainmentEList list = (EObjectContainmentEList)object;
		return createPropertyValueWrapper(list, new Integer(list.size()));
	}
	
	public boolean isPropertySet(Object object) {
		EObjectContainmentEList list = (EObjectContainmentEList)object;
		return (list.size() > 0);
	}

	public void resetPropertyValue(Object object) {
		// Because List objects are unchangeable, this is a no-op.
	}

	public void setPropertyValue(Object object, Object value) {
		// Because List objects are unchangeable, this is a no-op.
	}
}
