/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EObjectListItemProvider.java,v 1.1 2005/06/07 04:04:15 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.hyades.probekit.editor.internal.provider;

import java.util.Collection;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitUtil;



public class EObjectListItemProvider extends ItemProviderAdapter {
	public EObjectListItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}
	
	public Object getParent(Object object) {
		if(object instanceof EObjectContainmentEList) {
			return ((EObjectContainmentEList)object).getEObject();
		}
		return super.getParent(object);
	}

	protected CommandParameter unwrapCommandValues(CommandParameter commandParameter, Class commandClass) {
		// Check if the CommandParameter's object is a Collection of an EObjectContainmentList.
		// If so, remove its outer wrapper.
		Collection c = commandParameter.getCollection();
		commandParameter.collection = ProbekitUtil.unwrap(c);
		return super.unwrapCommandValues(commandParameter, commandClass);
	}
}
