/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EObjectListProviderAdapter.java,v 1.1 2005/06/07 04:04:15 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.hyades.probekit.editor.internal.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;

public class EObjectListProviderAdapter extends EObjectListItemProvider  {
	protected EObjectListProviderAdapter(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}
	
	public Collection getChildren(Object object) {
		ChildrenStore store = getChildrenStore(object);
		if (store != null) {
			return store.getChildren();
		}

		store = createChildrenStore(object);
		List result = store != null ? null : new ArrayList();
		EObject eObject = (EObject) object;

		for (Iterator i = getChildrenFeatures(object).iterator(); i.hasNext();) {
			EStructuralFeature feature = (EStructuralFeature) i.next();
			if (displayManyAsSingle(feature)) {
				addSingleFeature(eObject, feature, store, result);
			} else if (feature.isMany()) {
				addManyFeature(eObject, feature, store, result);
			} else {
				addSingleFeature(eObject, feature, store, result);
			}

		}
		return store != null ? store.getChildren() : result;
	}

	protected boolean displayManyAsSingle(EStructuralFeature feature) {
		// Special processing for Import and Target so that, instead
		// of displaying each as a leaf, the group of Import/Target
		// is displayed as a leaf.
		return EObjectListSwitch.isSwitchForFeature(feature);
	}

	protected void addManyFeature(EObject eObject, EStructuralFeature feature, ChildrenStore store, List result) {
		List children = (List) eObject.eGet(feature);
		int index = 0;
		for (Iterator ci = children.iterator(); ci.hasNext(); index++) {
			Object child = wrap(eObject, feature, ci.next(), index);
			if (store != null) {
				store.getList(feature).add(child);
			} else {
				result.add(child);
			}
		}
	}

	protected void addSingleFeature(EObject eObject, EStructuralFeature feature, ChildrenStore store, List result) {
		Object child = eObject.eGet(feature);
		if (child != null) {
			child = wrap(eObject, feature, child, CommandParameter.NO_INDEX);
			if (store != null) {
				store.setValue(feature, child);
			} else {
				result.add(child);
			}
		}
	}
}
