/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EObjectListSwitch.java,v 1.1 2005/06/07 04:04:15 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.hyades.probekit.editor.internal.provider;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;


public class EObjectListSwitch {
	public EObjectListSwitch() {
	}
	
	public static boolean isSwitchForType(Object object, Object type) {
		EStructuralFeature feature = getFeature(object);
		return isSwitchForFeature(feature);
	}
	
	public static boolean isSwitchForFeature(EStructuralFeature feature) {
		if(feature == null) {
			return false;
		}
		
		if(feature.equals(ProbekitPackage.eINSTANCE.getProbe_Import())) {
			return true;
		}
		else if(feature.equals(ProbekitPackage.eINSTANCE.getProbe_Target())) {
			return true;
		}
		return false;
	}
	
	public static EStructuralFeature getFeature(Object object) {
		if(object instanceof EObjectContainmentEList) {
			EObjectContainmentEList theList = (EObjectContainmentEList)object;
			return (EStructuralFeature)theList.getFeature();
		}
		else if(object instanceof EStructuralFeature) {
			return ((EStructuralFeature)object);
		}
		return null;
	}
	
	public Adapter doSwitch(Object object, Object type) {
		EStructuralFeature feature = getFeature(object);
		if(feature == null) {
			return defaultCase();
		}
		
		switch (feature.getFeatureID()) {
			case ProbekitPackage.PROBE__IMPORT: {
				Adapter result = createAllImportsProvider(object);

				if (result == null) result = defaultCase();
				return result;
			}
			
			case ProbekitPackage.PROBE__TARGET: {
				Adapter result = createAllTargetsProvider(object);

				if (result == null) result = defaultCase();
				return result;
			}
			
			default: {
				return defaultCase();
			}
		}
	}

	private Adapter defaultCase() {
		return null;
	}
	
	public Adapter createAllImportsProvider(Object object) {
		return null;
	}

	public Adapter createAllTargetsProvider(Object object) {
		return null;
	}
}