/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FragmentItemProvider.java,v 1.1 2005/06/07 04:04:15 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit.editor.internal.provider;



import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.hyades.models.internal.probekit.DataItem;
import org.eclipse.hyades.models.internal.probekit.Fragment;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.probekit.editor.internal.presentation.codeassist.JavaSnippet;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;


/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.models.internal.probekit.Fragment} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class FragmentItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FragmentItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);


			addCodePropertyDescriptor(object);

			addTypePropertyDescriptor(object);

		}
		return itemPropertyDescriptors;
	}


	/**
	 * This adds a property descriptor for the Code feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addCodePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("_UI_Fragment_code_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Fragment_code_feature", "_UI_Fragment_type"),
				 ProbekitPackage.eINSTANCE.getFragment_Code(),

				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));

	}


	/**
	 * This adds a property descriptor for the Type feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addTypePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("_UI_Fragment_type_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Fragment_type_feature", "_UI_Fragment_type"),
				 ProbekitPackage.eINSTANCE.getFragment_Type(),

				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));

	}


	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);

//			childrenFeatures.add(ProbekitPackage.eINSTANCE.getFragment_Data());

		}
		return childrenFeatures;
	}



	/**
	 * This returns Fragment.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		Object image = JavaSnippet.getImageURL(object);
		if(image != null) {
			return image;
		}
		return getResourceLocator().getImage("full/obj16/Fragment");
	}


	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText(Object object) {
		String type = ((Fragment)object).getType().toString();

		return type == null || type.length() == 0 ?
			getString("_UI_Fragment_type") :
			getString("_UI_Fragment_type") + " (" + type + ")";
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		updateChildren(notification);


		switch (notification.getFeatureID(Fragment.class)) {
			case ProbekitPackage.FRAGMENT__CODE:

			case ProbekitPackage.FRAGMENT__TYPE:

				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;

			case ProbekitPackage.FRAGMENT__DATA:

				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;

		}

		super.notifyChanged(notification);
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return ProbekitUIPlugin.INSTANCE;
	}

	public void addAndNotify(Fragment fragment, DataItem item) {
		EditingDomain domain = findEditingDomain(fragment);
		if(domain != null) {
			CreateChildCommand command = new CreateChildCommand(domain, fragment, ProbekitPackage.eINSTANCE.getFragment_Data(), item, Collections.EMPTY_LIST);
			executeCommand(domain, command);
		}
	}
	
	public void removeAndNotify(Fragment fragment, DataItem item) {
		EditingDomain domain = findEditingDomain(fragment);
		if(domain != null) {
			RemoveCommand command = new RemoveCommand(domain, fragment, ProbekitPackage.eINSTANCE.getFragment_Data(), item);
			executeCommand(domain, command);
		}
	}
	
	public void updateAndNotify(Fragment fragment, int index, DataItem item) {
		EditingDomain domain = findEditingDomain(fragment);
		if(domain != null) {
			SetCommand command = new SetCommand(domain, fragment, ProbekitPackage.eINSTANCE.getFragment_Data(), item, index);
			domain.getCommandStack().execute(command);
		}
	}
	
	private EditingDomain findEditingDomain(Fragment fragment) {
		return AdapterFactoryEditingDomain.getEditingDomainFor(fragment);
	}
	
	private void executeCommand(EditingDomain domain, Command command) {
		if((domain != null) && (command != null)) {
		    domain.getCommandStack().execute(command);
		}
	}
}

