/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProbeItemProvider.java,v 1.1 2005/06/07 04:04:15 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit.editor.internal.provider;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.hyades.models.internal.probekit.Probe;
import org.eclipse.hyades.models.internal.probekit.ProbekitFactory;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.probekit.editor.internal.presentation.codeassist.JavaSnippet;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;


/**
 * This is the item provider adpater for a
 * {@link org.eclipse.hyades.models.internal.probekit.Probe}object. <!--
 * begin-user-doc --> <!-- end-user-doc -->
 * 
 * @generated NOT
 */
public class ProbeItemProvider 
	extends EObjectListProviderAdapter 
	implements 
		IEditingDomainItemProvider, 
		IStructuredItemContentProvider, 
		ITreeItemContentProvider, 
		IItemLabelProvider, 
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ProbeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addFragmentAtClassScopePropertyDescriptor(object);

		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Fragment At Class Scope feature.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void addFragmentAtClassScopePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(new ItemPropertyDescriptor(((ComposeableAdapterFactory) adapterFactory).getRootAdapterFactory(), getString("_UI_Probe_fragmentAtClassScope_feature"), getString("_UI_PropertyDescriptor_description", "_UI_Probe_fragmentAtClassScope_feature", "_UI_Probe_type"), ProbekitPackage.eINSTANCE.getProbe_FragmentAtClassScope(),

		true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));

	}

	/**
	 * This specifies how to implement {@link #getChildren}and is used to
	 * deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand},
	 * {@link org.eclipse.emf.edit.command.RemoveCommand}or
	 * {@link org.eclipse.emf.edit.command.MoveCommand}in
	 * {@link #createCommand}. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public Collection getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);

			//			childrenFeatures.add(ProbekitPackage.eINSTANCE.getProbe_Name());
			//
			//			childrenFeatures.add(ProbekitPackage.eINSTANCE.getProbe_Description());

			//			childrenFeatures.add(ProbekitPackage.eINSTANCE.getProbe_ControlKey());
			//
			//			childrenFeatures.add(ProbekitPackage.eINSTANCE.getProbe_ControlName());

			childrenFeatures.add(ProbekitPackage.eINSTANCE.getProbe_Target());

			childrenFeatures.add(ProbekitPackage.eINSTANCE.getProbe_Import());

			childrenFeatures.add(ProbekitPackage.eINSTANCE.getProbe_Fragment());

			//			childrenFeatures.add(ProbekitPackage.eINSTANCE.getProbe_InvocationObject());

			childrenFeatures.add(ProbekitPackage.eINSTANCE.getProbe_StaticField());

		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper
		// feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * This returns Probe.gif. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Object getImage(Object object) {
		Object image = JavaSnippet.getImageURL(object);
		if(image != null) {
			return image;
		}
		return getResourceLocator().getImage("full/obj16/Probe");
	}

	/**
	 * This returns the label text for the adapted class. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public String getText(Object object) {
		return getString("_UI_Probe_type");
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren}to
	 * update any cached children and by creating a viewer notification, which
	 * it passes to {@link #fireNotifyChanged}. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(Probe.class)) {
		case ProbekitPackage.PROBE__FRAGMENT_AT_CLASS_SCOPE:

			fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
			return;

		//			case ProbekitPackage.PROBE__NAME:
		//
		//			case ProbekitPackage.PROBE__DESCRIPTION:

		//			case ProbekitPackage.PROBE__CONTROL_KEY:
		//
		//			case ProbekitPackage.PROBE__CONTROL_NAME:

		case ProbekitPackage.PROBE__TARGET:

		case ProbekitPackage.PROBE__IMPORT:

		case ProbekitPackage.PROBE__FRAGMENT:

		//			case ProbekitPackage.PROBE__INVOCATION_OBJECT:

		case ProbekitPackage.PROBE__STATIC_FIELD:

			fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
			return;

		}

		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of
	 * {@link org.eclipse.emf.edit.command.CommandParameter}s describing all of
	 * the children that can be created under this object. <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		//		newChildDescriptors.add
		//			(createChildParameter
		//				(ProbekitPackage.eINSTANCE.getProbe_Name(),
		//
		//				 ProbekitFactory.eINSTANCE.createName()));
		//
		//
		//		newChildDescriptors.add
		//			(createChildParameter
		//				(ProbekitPackage.eINSTANCE.getProbe_Description(),
		//
		//				 ProbekitFactory.eINSTANCE.createDescription()));
		//
		//
		//		newChildDescriptors.add
		//			(createChildParameter
		//				(ProbekitPackage.eINSTANCE.getProbe_ControlKey(),
		//
		//				 ProbekitFactory.eINSTANCE.createControlKey()));
		//
		//
		//		newChildDescriptors.add
		//			(createChildParameter
		//				(ProbekitPackage.eINSTANCE.getProbe_ControlName(),
		//
		//				 ProbekitFactory.eINSTANCE.createControlName()));

		// newChildDescriptors.add(createChildParameter(ProbekitPackage.eINSTANCE.getProbe_Target(),
		//
		// ProbekitFactory.eINSTANCE.createTarget()));
		//
		// newChildDescriptors.add(createChildParameter(ProbekitPackage.eINSTANCE.getProbe_Import(),
		//
		// ProbekitFactory.eINSTANCE.createImport()));

		newChildDescriptors.add(createChildParameter(ProbekitPackage.eINSTANCE.getProbe_Fragment(),

		ProbekitFactory.eINSTANCE.createFragment()));

		//		newChildDescriptors.add
		//			(createChildParameter
		//				(ProbekitPackage.eINSTANCE.getProbe_InvocationObject(),
		//
		//				 ProbekitFactory.eINSTANCE.createInvocationObject()));

		newChildDescriptors.add(createChildParameter(ProbekitPackage.eINSTANCE.getProbe_StaticField(),

		ProbekitFactory.eINSTANCE.createStaticField()));

	}

	/**
	 * Return the resource locator for this item provider's resources. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return ProbekitUIPlugin.INSTANCE;
	}
}

