/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProbekitItemProvider.java,v 1.1 2005/06/07 04:04:15 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit.editor.internal.provider;



import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.FeatureMapEntryWrapperItemProvider;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.hyades.models.internal.probekit.Probekit;
import org.eclipse.hyades.models.internal.probekit.ProbekitFactory;
import org.eclipse.hyades.models.internal.probekit.ProbekitPackage;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;


/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.models.internal.probekit.Probekit} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ProbekitItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProbekitItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);


			addIdPropertyDescriptor(object);

			addVersionPropertyDescriptor(object);

		}
		return itemPropertyDescriptors;
	}


	/**
	 * This adds a property descriptor for the Id feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addIdPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("PROBE_ID"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Probekit_id_feature", "_UI_Probekit_type"),
				 ProbekitPackage.eINSTANCE.getProbekit_Id(),

				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));

	}


	/**
	 * This adds a property descriptor for the Version feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addVersionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("_UI_Probekit_version_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_Probekit_version_feature", "_UI_Probekit_type"),
				 ProbekitPackage.eINSTANCE.getProbekit_Version(),

				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));

	}


	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);

			childrenFeatures.add(ProbekitPackage.eINSTANCE.getProbekit_Label());

			childrenFeatures.add(ProbekitPackage.eINSTANCE.getProbekit_Probe());

		}
		return childrenFeatures;
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}



	/**
	 * This returns Probekit.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getImage(Object object) {
		return getResourceLocator().getImage("full/obj16/Probekit");
	}


	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String getText(Object object) {
		String id = ((Probekit)object).getId();
		String version = ((Probekit)object).getVersion();

		String displayString = getString("_UI_Probekit_type");
		if (id != null && id.length() != 0)
			displayString = displayString + " " + id;
		if (version !=null && version.length() != 0)
			displayString = displayString + " " + version;
			
		return displayString;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.edit.provider.ItemProviderAdapter#createWrapper(org.eclipse.emf.ecore.EObject, org.eclipse.emf.ecore.EStructuralFeature, java.lang.Object, int)
	 */
	protected Object createWrapper(EObject object, EStructuralFeature feature, Object value, int index) {
	    if (FeatureMapUtil.isFeatureMap(feature))
	    {
	    	return new FeatureMapEntryWrapperItemProvider((FeatureMap.Entry)value, object, (EAttribute)feature, index, adapterFactory, null){
			/* (non-Javadoc)
			 * @see org.eclipse.emf.edit.provider.FeatureMapEntryWrapperItemProvider#getText(java.lang.Object)
			 */
			  protected String addEntryFeature(String text)
			  {
			    return text;
			  }
	    	};
		}
	    else
	    	return super.createWrapper(object,feature,value,index);
	    		
	}
	
	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void notifyChanged(Notification notification) {
		updateChildren(notification);


		switch (notification.getFeatureID(Probekit.class)) {
			case ProbekitPackage.PROBEKIT__ID:

			case ProbekitPackage.PROBEKIT__VERSION:

				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;

			case ProbekitPackage.PROBEKIT__LABEL:

			case ProbekitPackage.PROBEKIT__PROBE:

				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;

		}

		super.notifyChanged(notification);
	}


	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);


		newChildDescriptors.add
			(createChildParameter
				(ProbekitPackage.eINSTANCE.getProbekit_Label(),

				 ProbekitFactory.eINSTANCE.createLabel()));


		newChildDescriptors.add
			(createChildParameter
				(ProbekitPackage.eINSTANCE.getProbekit_Probe(),

				 ProbekitFactory.eINSTANCE.createProbe()));

	}


	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return ProbekitUIPlugin.INSTANCE;
	}
}

