/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProbekitItemProviderAdapterFactory.java,v 1.1 2005/06/07 04:04:15 popescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.probekit.editor.internal.provider;


import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.hyades.models.internal.probekit.util.ProbekitAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated NOT
 */
public class ProbekitItemProviderAdapterFactory extends ProbekitAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection supportedTypes = new ArrayList();

	
	protected EObjectListSwitch eObjectListSwitch = new EObjectListSwitch() {
		public Adapter createAllImportsProvider(Object object) {
			return createAllImportsProviderAdapter();
		}
		
		public Adapter createAllTargetsProvider(Object object) {
			return createAllTargetsProviderAdapter();
		}
	};

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProbekitItemProviderAdapterFactory() {
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemPropertySource.class);
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
	}


	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.models.internal.probekit.ControlKey} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ControlKeyItemProvider controlKeyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.models.internal.probekit.ControlKey}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createControlKeyAdapter() {
		if (controlKeyItemProvider == null) {
			controlKeyItemProvider = new ControlKeyItemProvider(this);
		}

		return controlKeyItemProvider;
	}


	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.models.internal.probekit.ControlName} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ControlNameItemProvider controlNameItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.models.internal.probekit.ControlName}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createControlNameAdapter() {
		if (controlNameItemProvider == null) {
			controlNameItemProvider = new ControlNameItemProvider(this);
		}

		return controlNameItemProvider;
	}


	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.models.internal.probekit.Description} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DescriptionItemProvider descriptionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.models.internal.probekit.Description}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDescriptionAdapter() {
		if (descriptionItemProvider == null) {
			descriptionItemProvider = new DescriptionItemProvider(this);
		}

		return descriptionItemProvider;
	}


	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.models.internal.probekit.DocumentRoot} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DocumentRootItemProvider documentRootItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.models.internal.probekit.DocumentRoot}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDocumentRootAdapter() {
		if (documentRootItemProvider == null) {
			documentRootItemProvider = new DocumentRootItemProvider(this);
		}

		return documentRootItemProvider;
	}


	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.models.internal.probekit.Fragment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FragmentItemProvider fragmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.models.internal.probekit.Fragment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createFragmentAdapter() {
		if (fragmentItemProvider == null) {
			fragmentItemProvider = new FragmentItemProvider(this);
		}

		return fragmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.models.internal.probekit.Import} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImportItemProvider importItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.models.internal.probekit.Import}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createImportAdapter() {
		if (importItemProvider == null) {
			importItemProvider = new ImportItemProvider(this);
		}
	
		return importItemProvider;
	}

	protected AllImportsItemProvider allImportsItemProvider;
	public Adapter createAllImportsProviderAdapter() {
		if(allImportsItemProvider == null) {
			allImportsItemProvider = new AllImportsItemProvider(this);
		}
		return allImportsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.models.internal.probekit.InvocationObject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InvocationObjectItemProvider invocationObjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.models.internal.probekit.InvocationObject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createInvocationObjectAdapter() {
		if (invocationObjectItemProvider == null) {
			invocationObjectItemProvider = new InvocationObjectItemProvider(this);
		}

		return invocationObjectItemProvider;
	}


	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.models.internal.probekit.Label} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LabelItemProvider labelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.models.internal.probekit.Label}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createLabelAdapter() {
		if (labelItemProvider == null) {
			labelItemProvider = new LabelItemProvider(this);
		}

		return labelItemProvider;
	}


	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.models.internal.probekit.Name} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NameItemProvider nameItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.models.internal.probekit.Name}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createNameAdapter() {
		if (nameItemProvider == null) {
			nameItemProvider = new NameItemProvider(this);
		}

		return nameItemProvider;
	}


	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.models.internal.probekit.Probe} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProbeItemProvider probeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.models.internal.probekit.Probe}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createProbeAdapter() {
		if (probeItemProvider == null) {
			probeItemProvider = new ProbeItemProvider(this);
		}

		return probeItemProvider;
	}


	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.models.internal.probekit.Probekit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProbekitItemProvider probekitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.models.internal.probekit.Probekit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createProbekitAdapter() {
		if (probekitItemProvider == null) {
			probekitItemProvider = new ProbekitItemProvider(this);
		}

		return probekitItemProvider;
	}


	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.models.internal.probekit.StaticField} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StaticFieldItemProvider staticFieldItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.models.internal.probekit.StaticField}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createStaticFieldAdapter() {
		if (staticFieldItemProvider == null) {
			staticFieldItemProvider = new StaticFieldItemProvider(this);
		}

		return staticFieldItemProvider;
	}


	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.hyades.models.internal.probekit.Target} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TargetItemProvider targetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.hyades.models.internal.probekit.Target}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createTargetAdapter() {
		if (targetItemProvider == null) {
			targetItemProvider = new TargetItemProvider(this);
		}

		return targetItemProvider;
	}

	protected AllTargetsItemProvider allTargetsItemProvider;
	public Adapter createAllTargetsProviderAdapter() {
		if (allTargetsItemProvider == null) {
			allTargetsItemProvider = new AllTargetsItemProvider(this);
		}

		return allTargetsItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Adapter adapt(Notifier notifier, Object type) {
		if(EObjectListSwitch.isSwitchForType(notifier, type)) {
			return eObjectListSwitch.doSwitch(notifier, type);
		}
		else {
			return super.adapt(notifier, this);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			if(EObjectListSwitch.isSwitchForType(object, type)) {
				return eObjectListSwitch.doSwitch(object, type);
			}
			else {
				Object adapter = super.adapt(object, type);
				if (!(type instanceof Class) || (((Class)type).isInstance(adapter))) {
					return adapter;
				}
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}
}

