/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProbeSourceFileWizard.java,v 1.5 2006/02/06 18:06:21 ewchan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/


package org.eclipse.hyades.probekit.editor.internal.ui.newFile;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.CreateInitialModelOperation;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.MethodProbeMetaData;
import org.eclipse.hyades.probekit.editor.internal.core.newFile.ProbeFileModel;
import org.eclipse.hyades.probekit.editor.internal.core.util.JavaUtil;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitMessages;
import org.eclipse.hyades.probekit.editor.internal.core.util.ProbekitUtil;
import org.eclipse.hyades.probekit.ui.internal.AddProbeNatureOperation;
import org.eclipse.hyades.probekit.ui.internal.ProbekitUIPlugin;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;



public class ProbeSourceFileWizard extends Wizard implements INewWizard {
	private IStructuredSelection _selection;
	private IWorkbench _workbench;
	ProbeFileModel _model = null;

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		_workbench = workbench;
		_selection = selection;
		_model = new ProbeFileModel(new MethodProbeMetaData());
		_model.setSourceContainer(getSelection());
		setWindowTitle(ProbekitMessages._37);
		setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(ProbekitUIPlugin.INSTANCE.getImage(ProbekitUtil.PROBEKIT_ICON_PATH)));
	}
	
	public boolean performFinish() {
		return createProbeFile();
	}
	
	
	
	// Return true if successful, false if not.
	private boolean createProbeFile() {
		try {
			_model.forceValid();
			final IFile modelFile = _model.getModelFile();
			final ArrayList list = new ArrayList(1);
			list.add(modelFile.getProject());
			
			IRunnableWithProgress operation = new WorkspaceModifyOperation() {
				public void execute(IProgressMonitor monitor) {
					try
					{
						AddProbeNatureOperation addProbeNature = new AddProbeNatureOperation(list);
						addProbeNature.run(monitor);
					}
					catch (CoreException ex)
					{
						// TODO Auto-generated catch block
						ex.printStackTrace();
					}
					finally 
					{
						monitor.done();
					}
				}
			};
			
			try
			{
				getContainer().run(true, true, operation);			
			}
			catch (InvocationTargetException exec)
			{
				// TODO Auto-generated catch block
				exec.printStackTrace();
			}
			catch (InterruptedException exec)
			{
				// TODO Auto-generated catch block
				exec.printStackTrace();
			}
			

			// Do the work within an operation.
			IRunnableWithProgress wrapper = new IRunnableWithProgress() {
				public void run(IProgressMonitor monitor) throws InvocationTargetException {
					try {
						CreateInitialModelOperation operation = 
							new CreateInitialModelOperation(_model);
						ResourcesPlugin.getWorkspace().run(operation, ResourcesPlugin.getWorkspace().getRoot(), IStatus.OK, monitor);
					}
					catch(CoreException exc) {
						throw new InvocationTargetException(exc);
					}
				}
			};
			getContainer().run(false, false, wrapper);

			// Select the new file resource in the current view.
			IWorkbenchPage page = selectResource(modelFile);
						

			// Open an editor on the new file.
			return openEditor(page, modelFile);
		}
		catch (JavaModelException exception) {
			ProbekitUIPlugin.INSTANCE.log(exception);
			return false;
		}
		catch (InterruptedException exception) {
			ProbekitUIPlugin.INSTANCE.log(exception);
			return false;
		}
		catch (InvocationTargetException exception) {
			ProbekitUIPlugin.INSTANCE.log(exception);
			return false;
		}
		finally {
		}
	}
	
	private IWorkbenchPage selectResource(IFile modelFile) {
		IWorkbenchWindow workbenchWindow = _workbench.getActiveWorkbenchWindow();
		IWorkbenchPage page = workbenchWindow.getActivePage();
		final IWorkbenchPart activePart = page.getActivePart();
		if (activePart instanceof ISetSelectionTarget) {
			final ISelection targetSelection = new StructuredSelection(modelFile);
			getShell().getDisplay().asyncExec
				(new Runnable() {
					 public void run() {
						 ((ISetSelectionTarget)activePart).selectReveal(targetSelection);
					 }
				 });
		}
		return page;
	}
	
	private boolean openEditor(IWorkbenchPage page, IFile modelFile) {
		try {
			page.openEditor
				(new FileEditorInput(modelFile),
				 _workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
		}
		catch (PartInitException exception) {
			MessageDialog.openError(
					getContainer().getShell(), 
					ProbekitMessages._1, 
					exception.getMessage());
			return false;
		}

		return true;
	}
	
	public void addPages() {
		addPage(new NewProbekitProbePage(_model));
		addPage(new NewProbekitDataPage(_model));
	}
	
	public IContainer getSelection() {
		if ((_selection == null) || _selection.isEmpty()) {
			return null;
		}
		
		Object element = _selection.getFirstElement();
		if(element instanceof IResource) {
			IResource res = (IResource)element;
			try {
				IContainer container = null;
				if(res.getType() == IResource.FILE) {
					container = res.getParent();
				}
				else {
					container = (IContainer)res;
				}
				if(JavaUtil.isSourceContainer(container)) {
					return container;
				}
			}
			catch(JavaModelException exc) {
				return null;
			}
		}
		
		return null;
	}
	
	public boolean performCancel() {
		_model.release();
		return super.performCancel();
	}
}
