/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddProbeNatureOperation.java,v 1.2 2006/02/06 18:06:21 ewchan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.probekit.ui.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

import org.eclipse.tptp.platform.probekit.builder.ProbeNature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;


public class AddProbeNatureOperation implements IWorkspaceRunnable {

	protected List _projectsToConvert;
	/**
	 * 
	 */
	public AddProbeNatureOperation(Collection selection) {
		super();
		_projectsToConvert = new ArrayList();
		// Extra validation of collection's expected format
		for (Iterator iter = selection.iterator(); iter.hasNext();)
		{
			Object obj = iter.next();
			if (obj instanceof IProject)
			{
				IProject project = (IProject) obj;
				if (project.isOpen())
				{
					try
					{
						if (project.hasNature(JavaCore.NATURE_ID) &&
							!project.hasNature(ProbeNature.NATURE_NAME))
						{
							// OK to convert since project is Java but not Probe
							_projectsToConvert.add(project);
						}
					}
					catch (CoreException e)
					{
						e.printStackTrace();
					}
				}
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.resources.IWorkspaceRunnable#run(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void run(IProgressMonitor monitor) throws CoreException
	{
		if (!_projectsToConvert.isEmpty())
		{
			//monitor.beginTask(Messages.getString("ConvertProject.AddNature"), _projectsToConvert.size());
			monitor.beginTask("", _projectsToConvert.size()); //$NON-NLS-1$
			for (Iterator iter = _projectsToConvert.iterator(); iter.hasNext();)
			{
				IProject project = (IProject) iter.next();
				monitor.setTaskName(NLS.bind(ProbekitUIMessages._1, project.getName())); //$NON-NLS-1$
				try
				{
					ProbeNature.addProbekitBuildNature(project, new SubProgressMonitor(monitor, 1));
				}
				catch (Exception e)
				{
					Shell shell = new Shell();
					MessageDialog.openError(shell, ProbekitUIMessages._2,  //$NON-NLS-1$
							NLS.bind(ProbekitUIMessages._3, project.getName())); //$NON-NLS-1$
				}
			}
			monitor.done();
		}
	}
}
