/**********************************************************************
Copyright (c) 2007, 2009 Intel Corporation and others.
All rights reserved. This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: ConfigGenerator.java,

Contributors:
    Intel Corporation - initial implementation
**********************************************************************/
package org.eclipse.tptp.platform.jvmti.runtime;

import org.eclipse.tptp.platform.agentcontroller.config.AgentControllerEnvironment;
import org.eclipse.tptp.platform.agentcontroller.config.Constants;
import org.eclipse.tptp.platform.agentcontroller.config.Option;
import org.eclipse.tptp.platform.agentcontroller.config.PluginConfig;
import org.eclipse.tptp.platform.agentcontroller.config.SetConfigSkeleton;
import org.eclipse.tptp.platform.agentcontroller.config.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/** 
* This class is used to generate JVMTI config for IAC
* 
*/
public class SetConfig extends SetConfigSkeleton {

	
	public void askUser() {
		/* Will not be used */
	}

	/**
	 * Generate JVMTI configuration file 
	 */
	public void generateConfiguration() {
		
		/* Path to the correct native files for the plugin */
		String nativePath = "%" + Constants.PLUGINS_HOME + "%" + sr + getPluginName() + sr + "agent_files";
		
		final String OPERATING_SYSTEM = System.getProperty("os.name").toLowerCase();
		final String SYSTEM_ARCH = System.getProperty("os.arch").toLowerCase();
		
		boolean error = false;
		
		/* Windows */
		if (OPERATING_SYSTEM.indexOf("windows") != -1)
		{	
			nativePath = nativePath + sr + "win";
			
			/* Now check the system architecture */		
						
			/* IA32 */
			if (SYSTEM_ARCH.indexOf("x86") != -1)
				nativePath = nativePath + "_ia32";
			/* S390X */
			else if (SYSTEM_ARCH.indexOf("s390x") != -1)
				nativePath = nativePath + "_s390x";
			/* S390 */
			else if (SYSTEM_ARCH.indexOf("s390") != -1)
				nativePath = nativePath + "_s390";
			/* EM64T */
			else if (SYSTEM_ARCH.indexOf("x86_64") != -1)
				nativePath = nativePath + "_em64t";
			/* AMD64 */
			else if (SYSTEM_ARCH.indexOf("amd64") != -1)
				nativePath = nativePath + "_em64t";
			/* IPF */
			else if (SYSTEM_ARCH.indexOf("ia64") != -1)
				nativePath = nativePath + "_ipf";
			/* Unknown architecture */
			else
				error = true;
			
		}
		/* Linux */
		else if (OPERATING_SYSTEM.indexOf("inux") != -1)
		{	
			nativePath = nativePath + sr + "linux";
			
			/* Now check the system architecture */		
			
			/* IA32 */
			if (SYSTEM_ARCH.indexOf("x86") != -1)
				nativePath = nativePath + "_ia32";
			else if (SYSTEM_ARCH.indexOf("i386") != -1)
				nativePath = nativePath + "_ia32";
			/* S390X */
			else if (SYSTEM_ARCH.indexOf("s390x") != -1)
				nativePath = nativePath + "_s390x";
			/* S390 */
			else if (SYSTEM_ARCH.indexOf("s390") != -1)
				nativePath = nativePath + "_s390";		
			/* EM64T */
			else if (SYSTEM_ARCH.indexOf("x86_64") != -1)
				nativePath = nativePath + "_em64t";
			/* AMD64 */
			else if (SYSTEM_ARCH.indexOf("amd64") != -1)
				nativePath = nativePath + "_em64t";
			/* IPF */
			else if (SYSTEM_ARCH.indexOf("ia64") != -1)
				nativePath = nativePath + "_ipf";
			/* Unknown architecture */
			else 
				error = true;
		}
		else
		{
			error = true;
		}
		
		/* Just return if there was an error */
		if (error)
			return;
		
		/* Standard initializer */
		Document doc = configFile.getDoc();
		if(doc == null) {
			return;
		}
		
		Element pluginConfigurationElement = doc.createElement(PluginConfig.TAG);
		Element holder = configFile.getHolder();
		holder.appendChild(pluginConfigurationElement);
		
		/* Create AgentControllerEnvironment element */
		Element acEnvironmentElement = doc.createElement(AgentControllerEnvironment.TAG);
		AgentControllerEnvironment.setConfiguration(acEnvironmentElement, "default");
		pluginConfigurationElement.appendChild(acEnvironmentElement);
		
		/* Create JAVA_PROFILER_HOME Variable */
		Element javaProfilerHomeVar = doc.createElement(Variable.TAG);
		Variable.setName(javaProfilerHomeVar, "JAVA_PROFILER_HOME");
		Variable.setPosition(javaProfilerHomeVar, "replace");
		Variable.setValue(javaProfilerHomeVar, nativePath);
		acEnvironmentElement.appendChild(javaProfilerHomeVar);
		
		/* Add %RASERVER_HOME%\bin to PATH */
		Element acBinPathVariable = doc.createElement(Variable.TAG);
		Variable.setName(acBinPathVariable, "PATH");
		Variable.setPosition(acBinPathVariable, "prepend");
		Variable.setValue(acBinPathVariable, "%RASERVER_HOME%" + sr + "bin");
		acEnvironmentElement.appendChild(acBinPathVariable);
		
		/* Add %JAVA_PROFILER_HOME% to PATH */
		Element javaProfilerHomePathVariable = doc.createElement(Variable.TAG);
		Variable.setName(javaProfilerHomePathVariable, "PATH");
		Variable.setPosition(javaProfilerHomePathVariable, "prepend");
		Variable.setValue(javaProfilerHomePathVariable, "%JAVA_PROFILER_HOME%");
		acEnvironmentElement.appendChild(javaProfilerHomePathVariable);
		
		/* Add %JAVA_PATH% to PATH */
		Element javaPathVariable = doc.createElement(Variable.TAG);
		Variable.setName(javaPathVariable, "PATH");
		Variable.setPosition(javaPathVariable, "prepend");
		Variable.setValue(javaPathVariable, "%JAVA_PATH%");
		acEnvironmentElement.appendChild(javaPathVariable);
		
		/* Add %JAVA_PROFILER_HOME% to CLASSPATH */
		Element classPath = doc.createElement(Variable.TAG);
		Variable.setName(classPath, "CLASSPATH");
		Variable.setPosition(classPath, "prepend");
		Variable.setValue(classPath, "%JAVA_PROFILER_HOME%");
		acEnvironmentElement.appendChild(classPath);
		
		if(OPERATING_SYSTEM.indexOf("aix") != -1) {
			Element ldPath = doc.createElement(Variable.TAG);
			Variable.setName(ldPath, "LIBPATH");
			Variable.setPosition(ldPath, "prepend");
			Variable.setValue(ldPath, "%JAVA_PROFILER_HOME%");
			acEnvironmentElement.appendChild(ldPath);
		}

		if(OPERATING_SYSTEM.indexOf("z/os") != -1) {
			Element ldPath = doc.createElement(Variable.TAG);
			Variable.setName(ldPath, "LIBPATH");
			Variable.setPosition(ldPath, "prepend");
			Variable.setValue(ldPath, "%JAVA_PROFILER_HOME%");
			acEnvironmentElement.appendChild(ldPath);
		}
		
		//Add the LD_LIBRARY_PATH for Linux IAC
		if (OPERATING_SYSTEM.indexOf("linux") != -1 || OPERATING_SYSTEM.indexOf("solaris") != -1)
		{
			Element ldPath = doc.createElement(Variable.TAG);
			Variable.setName(ldPath, "LD_LIBRARY_PATH");
			Variable.setPosition(ldPath, "prepend");
			Variable.setValue(ldPath, "%JAVA_PROFILER_HOME%");
			acEnvironmentElement.appendChild(ldPath);
		}
		
		/* Add Option element for plugin version */
		Element optionElement = doc.createElement(Variable.TAG);
		Option.setType(optionElement, "version");
		if(getPluginName().indexOf('_') != -1) {
			Option.setName(optionElement, getPluginName().substring(0, getPluginName().lastIndexOf('_')));
			Option.setValue(optionElement, getPluginName().substring(getPluginName().lastIndexOf('_') + 1));
		}
		else {
			Option.setName(optionElement, getPluginName());
			Option.setValue(optionElement, "unknown");
		}
		pluginConfigurationElement.appendChild(optionElement);
		
		configFile.saveToFile();
	}

	public void printExamples() {
		/* Will not be used */
	}

	public void printHelp() {
		/* Will not be used */	
	}

}
