@rem *********************************************************************
@rem Copyright (c) 2006, 2010 Intel Corporation and others.
@rem All rights reserved.   This program and the accompanying materials
@rem are made available under the terms of the Eclipse Public License v1.0
@rem which accompanies this distribution, and is available at
@rem http://www.eclipse.org/legal/epl-v10.html
@rem $Id$
@rem
@rem Contributors:
@rem Intel - Initial API and implementation
@rem *********************************************************************
@rem
@echo off
rem *****************************************************************
rem * Martini Build Script for Windows IA-32/EM64T/IPF
rem * ================================================
rem * Usage:
rem * build_tptp_martini arch mode [clean]
rem *     arch: IA32 | EM64T | IPF
rem *     mode: release | debug
rem *     clean: clean up the build
rem *****************************************************************

setlocal
if /i "%1" == "" goto usage
if /i "%2" == "" goto usage

if /i "%3" == "clean" set MAKE_OPTIONS=recurse=1 clean
if /i "%2" == "release" (
	set MAKE_MODE=Release
) else ( 
	if /i "%2" == "debug" (
		set MAKE_MODE=Debug
	) else (
		goto usage
	)
)
	
if /i %1 == ia32  goto ia32
if /i %1 == em64t goto em64t
if /i %1 == ipf   goto ipf
goto usage

:ia32
set BUILD_PLAT=IA32
set SOLN_FILE=tptp_martini.sln
set SOLN_CFG=%BUILD_PLAT% %MAKE_MODE%
set PROJ_NAME=BuildMartini32
set PROJ_CFG="%BUILD_PLAT% %MAKE_MODE%|Win32"
if not defined JAVA_HOME goto error_java_home
if not exist %JAVA_HOME%\include\jvmti.h goto error_bad_java_home
set INCLUDE=%INCLUDE%;%JAVA_HOME%\include;%JAVA_HOME%\include\win32
echo Added %JAVA_HOME%\include;%JAVA_HOME%\include\win32 to INCLUDE path

echo Executing: devenv.com /NOLOGO /USEENV /BUILD "%SOLN_CFG%" /PROJECT %PROJ_NAME% /PROJECTCONFIG %PROJ_CFG% %SOLN_FILE%
devenv.com /NOLOGO /USEENV /BUILD "%SOLN_CFG%" /PROJECT %PROJ_NAME% /PROJECTCONFIG %PROJ_CFG% %SOLN_FILE%
goto end

:em64t
set MAKE_FILE=BuildMartiniEM64T.mak
set MAKE_CFG=BuildMartiniEM64T - Win32 EM64T %MAKE_MODE%
goto make

:ipf
set MAKE_FILE=BuildMartiniIPF.mak
set MAKE_CFG=BuildMartiniIPF - Win32 IPF %MAKE_MODE%

:make
if not defined JAVA_HOME goto error_java_home
if not exist %JAVA_HOME%\include\jvmti.h goto error_bad_java_home
set INCLUDE=%INCLUDE%;%JAVA_HOME%\include;%JAVA_HOME%\include\win32
echo Added %JAVA_HOME%\include;%JAVA_HOME%\include\win32 to INCLUDE path

echo Executing: NMAKE /F %MAKE_FILE% CFG="%MAKE_CFG%" %MAKE_OPTIONS%
NMAKE /F %MAKE_FILE% CFG="%MAKE_CFG%" %MAKE_OPTIONS%
if %errorlevel% == 0 (
	echo BUILD OK
) else (
	echo BUILD ERRORS
)
goto end

:error_java_home
echo Please set JAVA_HOME to a J2SE 5.0 JDK root
goto end

:error_bad_java_home
echo JAVA_HOME=%JAVA_HOME% is not a valid J2SE 5.0 JDK root
goto end

:usage
echo Martini Build Script for Windows
echo     %0 arch mode [clean]
echo where 
echo     arch: IA32 ^| EM64T ^| IPF
echo     mode: release ^| debug
echo     clean: clean up the build
echo For example:
echo     %0 IA32 release
goto :end

:end
