@rem *********************************************************************
@rem Copyright (c) 2006, 2010 Intel Corporation and others.
@rem All rights reserved.   This program and the accompanying materials
@rem are made available under the terms of the Eclipse Public License v1.0
@rem which accompanies this distribution, and is available at
@rem http://www.eclipse.org/legal/epl-v10.html
@rem $Id: build_tptp_profiler.bat,v 1.12 2010/05/22 03:24:53 jcayne Exp $
@rem
@rem Contributors:
@rem Intel - Initial API and implementation
@rem *********************************************************************
@rem
@echo off
rem *****************************************************************
rem * Profiler Build Script for Windows IA-32/EM64T/IPF
rem * ================================================
rem * Usage:
rem * build_tptp_profiler arch mode [clean]
rem *     arch: IA32 | EM64T | IPF
rem *     mode: release | debug
rem *     clean: clean up the build
rem *****************************************************************

setlocal
if /i "%1" == "" goto usage
if /i "%2" == "" goto usage

if /i "%3" == "clean" set MAKE_OPTIONS=recurse=1 clean
if /i "%2" == "release" (
	set MAKE_MODE=Release
) else ( 
	if /i "%2" == "debug" (
		set MAKE_MODE=Debug
	) else (
		goto usage
	)
)
	
if /i %1 == ia32  goto ia32
if /i %1 == em64t goto em64t
if /i %1 == ipf   goto ipf
goto usage

:ia32
set BUILD_PLAT=Win32
set SOLN_FILE=tptp_profiler.sln
set SOLN_CFG=%MAKE_MODE%
set PROJ_CFG="%MAKE_MODE%|%BUILD_PLAT%"
set PROJ_NAME1=BuildCGProf32
set PROJ_NAME2=BuildJPIAgent32
set PROJ_NAME3=BuildACCollector32
set PROJ_NAME4=BuildHeapProf32
set PROJ_NAME5=BuildThreadProf32
set PROJ_NAME6=BuildProbekitAgent32

if not defined TPTP_ACSDK_HOME goto error_acsdk_home
if not exist %TPTP_ACSDK_HOME%\include\tptp\agents\BaseCollectorImpl.h goto error_bad_acsdk_home
if not defined JAVA_HOME goto error_java_home
if not exist %JAVA_HOME%\include\jni.h goto error_bad_java_home

echo =============================================================

echo Executing: devenv.com /NOLOGO /USEENV /BUILD "%SOLN_CFG%" /PROJECT %PROJ_NAME1% /PROJECTCONFIG %PROJ_CFG% %SOLN_FILE%
devenv.com /NOLOGO /USEENV /BUILD "%SOLN_CFG%" /PROJECT %PROJ_NAME1% /PROJECTCONFIG %PROJ_CFG% %SOLN_FILE%

echo =============================================================

echo Executing: devenv.com /NOLOGO /USEENV /BUILD "%SOLN_CFG%" /PROJECT %PROJ_NAME2% /PROJECTCONFIG %PROJ_CFG% %SOLN_FILE%
devenv.com /NOLOGO /USEENV /BUILD "%SOLN_CFG%" /PROJECT %PROJ_NAME2% /PROJECTCONFIG %PROJ_CFG% %SOLN_FILE%

echo =============================================================

echo Executing: devenv.com /NOLOGO /USEENV /BUILD "%SOLN_CFG%" /PROJECT %PROJ_NAME3% /PROJECTCONFIG %PROJ_CFG% %SOLN_FILE%
devenv.com /NOLOGO /USEENV /BUILD "%SOLN_CFG%" /PROJECT %PROJ_NAME3% /PROJECTCONFIG %PROJ_CFG% %SOLN_FILE%

echo =============================================================

echo Executing: devenv.com /NOLOGO /USEENV /BUILD "%SOLN_CFG%" /PROJECT %PROJ_NAME4% /PROJECTCONFIG %PROJ_CFG% %SOLN_FILE%
devenv.com /NOLOGO /USEENV /BUILD "%SOLN_CFG%" /PROJECT %PROJ_NAME4% /PROJECTCONFIG %PROJ_CFG% %SOLN_FILE%

echo =============================================================

echo Executing: devenv.com /NOLOGO /USEENV /BUILD "%SOLN_CFG%" /PROJECT %PROJ_NAME5% /PROJECTCONFIG %PROJ_CFG% %SOLN_FILE%
devenv.com /NOLOGO /USEENV /BUILD "%SOLN_CFG%" /PROJECT %PROJ_NAME5% /PROJECTCONFIG %PROJ_CFG% %SOLN_FILE%

echo =============================================================

echo Executing: devenv.com /NOLOGO /USEENV /BUILD "%SOLN_CFG%" /PROJECT %PROJ_NAME6% /PROJECTCONFIG %PROJ_CFG% %SOLN_FILE%
devenv.com /NOLOGO /USEENV /BUILD "%SOLN_CFG%" /PROJECT %PROJ_NAME6% /PROJECTCONFIG %PROJ_CFG% %SOLN_FILE%

echo =============================================================

goto end

:em64t
set MAKE_FILE1=BuildCGProfEM64T.mak 
set MAKE_CFG1=BuildCGProfEM64T - Win32 %MAKE_MODE%
set MAKE_FILE2=BuildJPIAgentEM64T.mak 
set MAKE_CFG2=BuildJPIAgentEM64T - Win32 %MAKE_MODE%
set MAKE_FILE3=BuildACCollectorEM64T.mak 
set MAKE_CFG3=BuildACCollectorEM64T - Win32 %MAKE_MODE%
set MAKE_FILE4=BuildHeapProfEM64T.mak 
set MAKE_CFG4=BuildHeapProfEM64T - Win32 %MAKE_MODE%
set MAKE_FILE5=BuildThreadProfEM64T.mak 
set MAKE_CFG5=BuildThreadProfEM64T - Win32 %MAKE_MODE%
set MAKE_FILE6=BuildProbekitAgentEM64T.mak 
set MAKE_CFG6=BuildProbekitAgentEM64T - Win32 %MAKE_MODE%
goto make

:ipf
set MAKE_FILE1=BuildCGProfIPF.mak 
set MAKE_CFG1=BuildCGProfIPF - Win32 %MAKE_MODE%
set MAKE_FILE2=BuildJPIAgentIPF.mak 
set MAKE_CFG2=BuildJPIAgentIPF - Win32 %MAKE_MODE%
set MAKE_FILE3=BuildACCollectorIPF.mak 
set MAKE_CFG3=BuildACCollectorIPF - Win32 %MAKE_MODE%
set MAKE_FILE4=BuildHeapProfIPF.mak 
set MAKE_CFG4=BuildHeapProfIPF - Win32 %MAKE_MODE%
set MAKE_FILE5=BuildThreadProfIPF.mak 
set MAKE_CFG5=BuildThreadProfIPF - Win32 %MAKE_MODE%
set MAKE_FILE6=BuildProbekitAgentIPF.mak 
set MAKE_CFG6=BuildProbekitAgentIPF - Win32 %MAKE_MODE%

:make
if not defined TPTP_ACSDK_HOME goto error_acsdk_home
if not exist %TPTP_ACSDK_HOME%\include\tptp\agents\BaseCollectorImpl.h goto error_bad_acsdk_home
if not defined JAVA_HOME goto error_java_home
if not exist %JAVA_HOME%\include\jni.h goto error_bad_java_home

echo =============================================================

echo Executing: NMAKE /F %MAKE_FILE1% CFG="%MAKE_CFG1%" %MAKE_OPTIONS%
NMAKE /F %MAKE_FILE1% CFG="%MAKE_CFG1%" %MAKE_OPTIONS%
if %errorlevel% == 0 (
	echo BUILD OK
) else (
	echo BUILD ERRORS
)

echo =============================================================

echo Executing: NMAKE /F %MAKE_FILE2% CFG="%MAKE_CFG2%" %MAKE_OPTIONS%
NMAKE /F %MAKE_FILE2% CFG="%MAKE_CFG2%" %MAKE_OPTIONS%
if %errorlevel% == 0 (
 	echo BUILD OK
) else (
	echo BUILD ERRORS
)

echo =============================================================

echo Executing: NMAKE /F %MAKE_FILE3% CFG="%MAKE_CFG3%" %MAKE_OPTIONS%
NMAKE /F %MAKE_FILE3% CFG="%MAKE_CFG3%" %MAKE_OPTIONS%
if %errorlevel% == 0 (
 	echo BUILD OK
) else (
	echo BUILD ERRORS
)

echo =============================================================

echo Executing: NMAKE /F %MAKE_FILE4% CFG="%MAKE_CFG4%" %MAKE_OPTIONS%
NMAKE /F %MAKE_FILE4% CFG="%MAKE_CFG4%" %MAKE_OPTIONS%
if %errorlevel% == 0 (
 	echo BUILD OK
) else (
	echo BUILD ERRORS
)

echo =============================================================

echo Executing: NMAKE /F %MAKE_FILE5% CFG="%MAKE_CFG5%" %MAKE_OPTIONS%
NMAKE /F %MAKE_FILE5% CFG="%MAKE_CFG5%" %MAKE_OPTIONS%
if %errorlevel% == 0 (
 	echo BUILD OK
) else (
	echo BUILD ERRORS
)

echo =============================================================

echo Executing: NMAKE /F %MAKE_FILE6% CFG="%MAKE_CFG6%" %MAKE_OPTIONS%
NMAKE /F %MAKE_FILE6% CFG="%MAKE_CFG6%" %MAKE_OPTIONS%
if %errorlevel% == 0 (
 	echo BUILD OK
) else (
	echo BUILD ERRORS
)

echo =============================================================

goto end

:error_acsdk_home
echo Please set TPTP_ACSDK_HOME to a TPTP AC sdk root
goto end

:error_bad_acsdk_home
echo TPTP_ACSDK_HOME=%TPTP_ACSDK_HOME% is not a valid TPTP AC sdk root
goto end

:error_java_home
echo Please set JAVA_HOME to a J2SE 5.0 JDK root
goto end

:error_bad_java_home
echo JAVA_HOME=%JAVA_HOME% is not a valid J2SE 5.0 JDK root
goto end

:usage
echo Profiler Build Script for Windows
echo     %0 arch mode [clean]
echo where 
echo     arch: IA32 ^| EM64T ^| IPF
echo     mode: release ^| debug
echo     clean: clean up the build
echo For example:
echo     %0 IA32 release
goto :end

:end
