/************************************************************************
 * Copyright (c) 2005, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ACC_Env.h,v 1.16 2010/12/15 16:49:37 mreid Exp $ 
 ************************************************************************/

#ifndef _ACC_ENV_H_
#define _ACC_ENV_H_

#include <jni.h>

#ifdef _WIN32
  #define ACC_CALL __stdcall
  #define API_EXPORT __declspec(dllexport)
  #define API_IMPORT __declspec(dllimport)
#else
  #define ACC_CALL
  #define API_EXPORT 
  #define API_IMPORT
#endif

/*
#ifdef ACC_ENV_EXPORTS
  #define ACC_ENV_EXPORT API_EXPORT
#else
  #define ACC_ENV_EXPORT API_IMPORT
#endif
*/

namespace Martini { namespace ACCollector {

/**
 * Stores information about the heap instance data collected for the Object identified by TId.
 * Corresponds to THeapObjectAnalysis which is used to gather information about the Object, 
 * while MHeapObjectAnalysis returns the result to the client.
 */
typedef struct {
	char * TId; // TPTP ID of the Heap Object
	void * resultValue; // Result returned by the Agent for the client
} MHeapObjectAnalysis;

struct ACCFunctions_ {
    void (ACC_CALL *StartTracing)();
    void (ACC_CALL *StopTracing)();
    void (ACC_CALL *Detach)();
    void (ACC_CALL *Attach)();
    void (ACC_CALL *AddFilter)(char *iid, char *classPattern, char *methodPattern, char *filterMode);//strcmp("INCLUDE", mode) == 0 ? INCLUDE : EXCLUDE
    void (ACC_CALL *ApplyFilters)();
    void (ACC_CALL *SetProfileOption)(char *iid, char *name, char *value);
    void (ACC_CALL *AnalyseHeap)();
    void (ACC_CALL *RunGC)();
    bool (ACC_CALL *isHeapInstanceDataEnabled)();
    void (ACC_CALL *setHeapInstanceDataEnabled)();
    void (ACC_CALL *RunHeapObjectInstanceCollection)(MHeapObjectAnalysis *heapAnalysis);
    void (ACC_CALL *CollectAggData)();
    char* (ACC_CALL *GetProfiler)();
    bool (ACC_CALL *IsAgentInitialized)();
    void (ACC_CALL *EnableDataCollection)();
    char* (ACC_CALL *SetOutputFormat)(char *format);
    void (ACC_CALL *openSession)(JNIEnv**, bool*);
    void (ACC_CALL *closeSession)();
};

struct ACC_ENV {
    const struct ACCFunctions_ *functions;

    void StartTracing() {
        functions->StartTracing();
    }

    void StopTracing() {
        functions->StopTracing();
    }

    void Detach() {
        functions->Detach();
    }

    void Attach() {
        functions->Attach();
    }

    void AddFilter(char *iid, char *classPattern, char *methodPattern, char *filterMode) {
        functions->AddFilter(iid, classPattern, methodPattern, filterMode);
    }

    void ApplyFilters() {
        functions->ApplyFilters();
    }

    void SetProfileOption(char *iid, char *name, char *value) {
        functions->SetProfileOption(iid, name, value);
    }

    void AnalyseHeap() {
        functions->AnalyseHeap();
    }

    void RunGC() {
        functions->RunGC();
    }

   	// Determines if Heap Instance Data collection has been enabled by the passed options.
    bool isHeapInstanceDataEnabled() {
    	bool result = functions->isHeapInstanceDataEnabled();
    	return result;
    }

	// Enables Heap Instance Data collection by sending the custom command based on the option.
    void setHeapInstanceDataEnabled() {
		functions->setHeapInstanceDataEnabled();
	}

	// Runs Heap Object Instance Collection against the Object by sending the custom command
    // as requested by the client.
    void RunHeapObjectInstanceCollection(MHeapObjectAnalysis *heapAnalysis) {
        functions->RunHeapObjectInstanceCollection(heapAnalysis);
    }

    void CollectAggData() {
        functions->CollectAggData();
    }

	void EnableDataCollection() {
		functions->EnableDataCollection();
	}

    char* GetProfiler() {
        return functions->GetProfiler();
    }

    bool IsAgentInitialized() {
        return functions->IsAgentInitialized();
    }

	char *SetOutputFormat(char *format) {
		return functions->SetOutputFormat(format);
	}

	void openSession( JNIEnv** pEnv, bool* bAttach ) {
		functions->openSession(pEnv, bAttach);
	}

	void closeSession() {
		functions->closeSession();
	}
};

typedef int (*ACCollector_Init_t)(ACC_ENV* env, bool isControlled);
typedef int (*ACCollector_SendData_t)(char *s, unsigned short length);
typedef int (*ACCollector_SendVMAgentInitialized_t)();

//extern "C" ACC_ENV_EXPORT int ACCollector_Init(ACC_ENV* env, bool isControlled);

} /*namespace Martini*/ } /*namespace ACCollector*/

#endif // _ACC_ENV_H_ 
