/*************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation, Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: EC_Env.h,v 1.26 2010/05/25 14:48:19 jcayne Exp $ 
 ***********************************************************************/

#ifndef _EC_ENV_H_
#define _EC_ENV_H_

#include "MpiAPI.h"
#include "MartiniExternalControl.h"
#include "InStructs.h"

#ifdef _WIN32
  #define ECCALL __stdcall
  #define API_EXPORT __declspec(dllexport)
  #define API_IMPORT __declspec(dllimport)
#else
  #define ECCALL
  #define API_EXPORT 
  #define API_IMPORT
#endif

/*
#ifdef EC_ENV_EXPORTS
  #define EC_ENV_EXPORT API_EXPORT
#else
  #define EC_ENV_EXPORT API_IMPORT
#endif
*/

namespace Martini { namespace JPIAgent {

using namespace Martini::MPI;

typedef enum {
    EC_ENV_ERROR_NONE =                0,
    EC_ENV_ERROR_ILLEGAL_ARGUMENT =    103,
    EC_ENV_ERROR_OUT_OF_MEMORY =       110,
    EC_ENV_ERROR_INTERNAL =            113,
    EC_ENV_ERROR_ILLEGAL_STATE =       201,
    EC_ENV_ERROR_TIMEOUT =             203,
} EC_ENV_Error;

struct EC_Env;

struct ECFunctions_ {
    //General elements
    EC_ENV_Error (ECCALL *PrintThreadStartElement)(EC_Env* env, TId threadId, TId objectId, SThreadInfo* threadInfo);
    EC_ENV_Error (ECCALL *PrintThreadEndElement)(EC_Env* env, TId threadId);
    EC_ENV_Error (ECCALL *PrintClassDefElement)(EC_Env* env, TId classId, SClassInfo* classInfo);
    EC_ENV_Error (ECCALL *PrintRuntimeVMInitElement)(EC_Env* env, TId threadId);
    EC_ENV_Error (ECCALL *PrintRuntimeShutdownElement)(EC_Env* env);

    // Call Graph elements
    EC_ENV_Error (ECCALL *PrintMethodDefElement)(EC_Env* env, TId methodId, SMethodInfo* methodInfo);
    EC_ENV_Error (ECCALL *PrintMethodEntryElement)(EC_Env* env, TId threadId, TId methodId, TId classId, unsigned long ticket, unsigned long stackDepth);
    EC_ENV_Error (ECCALL *PrintAgMethodEntryElement)(EC_Env* env, TId threadId, TId methodId, U64 baseTime, U64 minTime, U64 maxTime, U64 baseCPUTime, U64 numCalls);
    EC_ENV_Error (ECCALL *PrintMethodExitElement)(EC_Env* env, TId threadId, TId methodId, TId classId, unsigned long ticket, U64 cpuTime);
    EC_ENV_Error (ECCALL *PrintAgMethodExitElement)(EC_Env* env, TId threadId, TId methodId);

    // Heap elements
    EC_ENV_Error (ECCALL *PrintObjAllocElement)(EC_Env* env, SHeapEventData* data, U64 lineNumber);
    EC_ENV_Error (ECCALL *PrintObjFreeElement)(EC_Env* env, SHeapEventData* data);
    EC_ENV_Error (ECCALL *PrintGcStartElement)(EC_Env* env);
    EC_ENV_Error (ECCALL *PrintGcFinishElement)(EC_Env* env);
    EC_ENV_Error (ECCALL *PrintHeapDumpDefElement)(EC_Env* env, TId heapDumpId, char* heapDefName, U64 basetime);
    EC_ENV_Error (ECCALL *PrintGcRootElement)(EC_Env* env, TId heapDumpIdRef, TId objIdRef, EObjectReferenceType type);
    EC_ENV_Error (ECCALL *PrintObjectReferenceElement)(EC_Env* env, TId heapDumpIdRef, SObjectReference* objRef);

    // Thread elements
    EC_ENV_Error (ECCALL *PrintMonitorWaitElement)(EC_Env* env, SMonitorWaitEventData* monitorWaitData, SStackTrace_* stackTrace);
    EC_ENV_Error (ECCALL *PrintMonitorWaitedElement)(EC_Env* env, SMonitorWaitedEventData* monitorWaitedData, U64 timeout, SStackTrace_* stackTrace);
    EC_ENV_Error (ECCALL *PrintMonitorContendedEnterElement)(EC_Env* env, SContendedMonitorEnterEventData* conMonEnterData, SStackTrace_* stackTrace);
    EC_ENV_Error (ECCALL *PrintMonitorContendedEnteredElement)(EC_Env* env, SContendedMonitorEnteredEventData* conMonEnteredData, SStackTrace_* stackTrace);
    EC_ENV_Error (ECCALL *printThreadInteractionElements)(EC_Env* env, SThreadInteractionEventData* threadInteractionData, SStackTrace_* stackTrace);

    EC_ENV_Error (ECCALL *PrintCustomElement)(EC_Env* env, const char *str);

    bool (ECCALL *IsExcluded)(EC_Env* env, const char *className, const char *methodName); 
    U64 (ECCALL *GetTime)(EC_Env* env); 
    int (ECCALL *SetProfileOption)(EC_Env* env, char * key, char * value);
    bool (ECCALL *isCGExecDetails)(EC_Env* env); 
    bool (ECCALL *isStackMemoryFree)(EC_Env* env);
    bool (ECCALL *isStackInfoNormal)(EC_Env* env);
    bool (ECCALL *isStandAlone)(EC_Env* env);
    bool (ECCALL *isControlled)(EC_Env* env);
    bool (ECCALL *isEnabled)(EC_Env* env);
    bool (ECCALL *isAllocSitesSupported)(EC_Env* env);
    bool (ECCALL *isContentionAnalysisSupported)(EC_Env* env);
    bool (ECCALL *isCalcStackMap)(EC_Env* env);
    bool (ECCALL *isHeapInstanceDataEnabled)(EC_Env* env);

	const char*(ECCALL *getUnknownOptionByName)(EC_Env* env, const char* name);

    void (ECCALL *VMInitDone)(EC_Env* env);

    int (ECCALL *getMaxStackDepth)(EC_Env* env);
};

struct EC_Env {
    const struct ECFunctions_ *functions;

    EC_ENV_Error PrintThreadStartElement(TId threadId, TId objectId, SThreadInfo* threadInfo) {
        return functions->PrintThreadStartElement(this, threadId, objectId, threadInfo);
    }

    EC_ENV_Error PrintThreadEndElement(TId threadId) {
        return functions->PrintThreadEndElement(this, threadId);
    }

    EC_ENV_Error PrintClassDefElement(TId classId, SClassInfo* classInfo) {
        return functions->PrintClassDefElement(this, classId, classInfo);
    }

    EC_ENV_Error PrintMethodDefElement(TId methodId, SMethodInfo* methodInfo) {
        return functions->PrintMethodDefElement(this, methodId, methodInfo);
    }

    EC_ENV_Error PrintMethodEntryElement(TId threadId, TId methodId, TId classId, unsigned long ticket, unsigned long stackDepth) {
        return functions->PrintMethodEntryElement(this, threadId, methodId, classId, ticket, stackDepth);
    }

    EC_ENV_Error PrintAgMethodEntryElement(TId threadId, TId methodId, U64 baseTime, U64 minTime, U64 maxTime, U64 baseCPUTime, U64 numCalls) {
        return functions->PrintAgMethodEntryElement(this, threadId, methodId, baseTime, minTime, maxTime, baseCPUTime, numCalls);
    }

    EC_ENV_Error PrintMethodExitElement(TId threadId, TId methodId, TId classId, unsigned long ticket, U64 cpuTime) {
        return functions->PrintMethodExitElement(this, threadId, methodId, classId, ticket, cpuTime);
    }

    EC_ENV_Error PrintAgMethodExitElement(TId threadId, TId methodId) {
        return functions->PrintAgMethodExitElement(this, threadId, methodId);
    }

    EC_ENV_Error PrintRuntimeVMInitElement(TId threadId) {
        return functions->PrintRuntimeVMInitElement(this, threadId);
    }

    EC_ENV_Error PrintRuntimeShutdownElement() {
        return functions->PrintRuntimeShutdownElement(this);
    }

    EC_ENV_Error PrintObjAllocElement(SHeapEventData* heapData, U64 lineNumber) {
        return functions->PrintObjAllocElement(this, heapData, lineNumber);
    }

    EC_ENV_Error PrintObjFreeElement(SHeapEventData* heapData) {
        return functions->PrintObjFreeElement(this, heapData);
    }

    EC_ENV_Error PrintGcStartElement() {
        return functions->PrintGcStartElement(this);
    }

    EC_ENV_Error PrintGcFinishElement() {
        return functions->PrintGcFinishElement(this);
    }

    EC_ENV_Error PrintHeapDumpDefElement(TId heapDumpId, char* heapDefName, U64 basetime) {
        return functions->PrintHeapDumpDefElement(this, heapDumpId, heapDefName, basetime);
    }

    EC_ENV_Error PrintGcRootElement(TId heapDumpIdRef, TId objIdRef, EObjectReferenceType type) {
        return functions->PrintGcRootElement(this, heapDumpIdRef, objIdRef, type);
    }

    EC_ENV_Error PrintObjectReferenceElement(TId heapDumpIdRef, SObjectReference* objRef) {
        return functions->PrintObjectReferenceElement(this, heapDumpIdRef, objRef);
    }

    EC_ENV_Error PrintMonitorWaitElement(SMonitorWaitEventData* monitorWaitData, SStackTrace_* stackTrace) {
        return functions->PrintMonitorWaitElement(this, monitorWaitData, stackTrace);
    }

    EC_ENV_Error PrintMonitorWaitedElement(SMonitorWaitedEventData* monitorWaitedData, U64 timeout, SStackTrace_* stackTrace) {
        return functions->PrintMonitorWaitedElement(this, monitorWaitedData, timeout, stackTrace);
    }

    EC_ENV_Error PrintMonitorContendedEnterElement(SContendedMonitorEnterEventData* conMonEnterData, SStackTrace_* stackTrace) {
        return functions->PrintMonitorContendedEnterElement(this, conMonEnterData, stackTrace);
    }

    EC_ENV_Error PrintMonitorContendedEnteredElement(SContendedMonitorEnteredEventData* conMonEnteredData, SStackTrace_* stackTrace) {
        return functions->PrintMonitorContendedEnteredElement(this, conMonEnteredData, stackTrace);
    }

    EC_ENV_Error printThreadInteractionElements(SThreadInteractionEventData* threadInteractionData, SStackTrace_* stackTrace) {
        return functions->printThreadInteractionElements(this, threadInteractionData, stackTrace);
    }


    EC_ENV_Error PrintCustomElement(const char *str) {
        return functions->PrintCustomElement(this, str);
    }

    bool IsExcluded(const char *className, const char *methodName) {
        return functions->IsExcluded(this, className, methodName);
    }

    U64 GetTime() {
        return functions->GetTime(this);
    }

    int SetProfileOption(char * key, char * value) {
        return functions->SetProfileOption(this, key, value);
    }
    
    bool isCGExecDetails() {
        return functions->isCGExecDetails(this);
    }

    bool isStackMemoryFree() {
        return functions->isStackMemoryFree(this);
    }

    bool isStackInfoNormal() {
        return functions->isStackInfoNormal(this);
    }

    bool isStandAlone() {
        return functions->isStandAlone(this);
    }

    bool isControlled() {
        return functions->isControlled(this);
    }

    bool isEnabled() {
        return functions->isEnabled(this);
    }

    bool isAllocSitesSupported() {
        return functions->isAllocSitesSupported(this);
    }

    bool isContentionAnalysisSupported() {
        return functions->isContentionAnalysisSupported(this);
    }

    bool isCalcStackMap() {
        return functions->isCalcStackMap(this);
    }

	// Used to check if heap instance data collection is enabled in the custom command call.
    bool isHeapInstanceDataEnabled() {
           return functions->isHeapInstanceDataEnabled(this);
    }

	const char* getUnknownOptionByName( const char* name ) {
		return functions->getUnknownOptionByName(this, name);
	}
		
    void VMInitDone() {
        functions->VMInitDone(this);
    }
    
    int getMaxStackDepth(){
    	return functions->getMaxStackDepth(this);
    }
};

typedef int (*GetEC_Env_t)(char* profName, EC_Env** env);

//extern "C" EC_ENV_EXPORT int GetEC_Env(EC_Env** env);

const unsigned int ANALYSE_HEAP_COMMAND = 1;
const unsigned int RUN_GC_COMMAND = 2;
const unsigned int COLLECT_DATA = 3;
const unsigned int ENABLE_DATA_COLLECTION = 4;
const unsigned int RUN_HEAP_OBJ_DATA_COLLECTION_CMD = 5;
const unsigned int SET_HEAP_OBJ_COLLECTION_CMD = 6;


} /*namespace Martini*/ } /*namespace JPIAgent*/

#endif // _EC_ENV_H_ 
