/************************************************************************
* Copyright (c) 2007 Intel Corporation.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*    Intel Corporation - Initial API and implementation
*    Viacheslav Rybalov, Intel - Initial API and implementation
*
* $Id: InStructs.h,v 1.5 2007/04/05 13:39:29 vrybalov Exp $ 
************************************************************************/

#ifndef _INSTRUCTS_H_
#define _INSTRUCTS_H_

#include "MpiAPI.h"

namespace Martini { namespace JPIAgent {

    /**
    * @brief Defines stack entry information
    *
    * Defines stack entry information. Used in the SStackTrace_ struct.
    */
    struct SStackEntry_
    {
        MPI::TId methodId;     //!< Method id
        char* methodName; // Method name
        U64 lineNumber;   //!< @brief Either the VM code offset from the beginning of the method,
                          //!  or the absolute native IP, depending on the requested stack
                          //!  trace type.
    };

    /**
    * @brief Defines a stack trace
    *
    * Defines stack trace information.
    *
    * For more information on using this structure, refer to 
    * @ref mpi_arrays "Working with MPI Arrays".
    **/
    struct SStackTrace_
    {
        SStackEntry_*     pStackEntries;    //!< Array of stack entries
        unsigned int      uiSize;           //!< @brief
                                            //!  The number of elements allocated for the 
                                            //!  @c pStackEntries array
    };

    struct SMethodEnterData_ 
    {
        MPI::TId threadId_;
        MPI::TId methodId_; 
        MPI::TId classId_;
        unsigned long ticket_;
        unsigned long stackDepth_;
    };

    struct SMethodLeaveData_
    {
        MPI::TId threadId_;
        MPI::TId methodId_; 
        MPI::TId classId_;
        unsigned long ticket_;
        U64 cpuTime_;
    };

    struct TimeMillis {
        U64 timeoutMillis;    
    };

} /*namespace Martini*/ } /*namespace JPIAgent*/

#endif // _INSTRUCTS_H_
