/************************************************************************
 * Copyright (c) 2005, 2009 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: log.h,v 1.5 2009/08/26 15:21:09 jwest Exp $ 
 ************************************************************************/

#ifndef _LOG_H_
#define _LOG_H_

#include <sstream>
#include <iostream>
#ifdef MVS
	#include <strstream>
#endif
#include "OSA.h"

extern Martini::OSA::IThreadSync* lockObject;

#ifdef MVS
	#define LOG_MESSAGE(message) { \
	    lockObject->Enter(); \
		std::strstream strMessage; \
		strMessage << message; \
	    Martini::OSA::logMessage(strMessage.str()); \
	    lockObject->Leave(); \
	}
#else
	#define LOG_MESSAGE(message) { \
	    lockObject->Enter(); \
	    std::cout << "[" << message << "]" << std::endl; \
	    lockObject->Leave(); \
	}
#endif

#ifdef MVS
	#define LOG_ERROR(message) { \
		lockObject->Enter(); \
		std::strstream strMessage; \
		strMessage << message; \
	    Martini::OSA::logErrorMessage(strMessage.str()); \
	    lockObject->Leave(); \
	}
#else
	#define LOG_ERROR(message) { \
	    lockObject->Enter(); \
	    std::cerr << "[Error: " << message << "]" << std::endl; \
	    lockObject->Leave(); \
	}
#endif

#define LOG_INFO(message) LOG_MESSAGE(message)

#define LOG_DIE(message) { \
    LOG_ERROR(message); \
    exit(-1); \
}

#if defined(DEBUG) || defined(_DEBUG)

#define LOG_TRACE(message) LOG_MESSAGE(message)
#define LOG_ASSERT(assert) { \
    if (!(assert)) { \
        LOG_DIE("assert \"" #assert "\" failed. File: " << __FILE__ << " Line:" << __LINE__); \
    } \
}

#else

#define LOG_TRACE(message)
#define LOG_ASSERT(assert)

#endif // DEBUG

#endif // _LOG_H_
