/*****************************************************************************
 * Copyright (c) 1997-2007, Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$ 
 *****************************************************************************/

#ifndef __MRTE_RESULTS_H
#define __MRTE_RESULTS_H

//////////////////////////////////////////////////////////////////////////
// Martini module lists for results
#define MRTE_RESULT_MODULE_GENERAL          0x00    
#define MRTE_RESULT_MODULE_MPI              0x01    
#define MRTE_RESULT_MODULE_JPI              0x02    
#define MRTE_RESULT_MODULE_CPI              0x03    
#define MRTE_RESULT_MODULE_JIE              0x04    
#define MRTE_RESULT_MODULE_CIE              0x05    
#define MRTE_RESULT_MODULE_RTUTIL           0x06    
#define MRTE_RESULT_MODULE_CLASS_PARSER     0x07    
#define MRTE_RESULT_MODULE_HEAP             0x08    
#define MRTE_RESULT_MODULE_OSA              0x09    

//////////////////////////////////////////////////////////////////////////
// macros for creating results
#define MRTE_RESULT_FIRST_VALUE(module) ((module << 20) | 0x00000001)
#define MRTE_ERROR_FIRST_VALUE(module)  ((module << 20) | 0x80000001)

//////////////////////////////////////////////////////////////////////////
// macros for checking success/failure and getting the error code
#define MRTE_SUCCEEDED(code)         (((code) &  MRTE_ERROR_FAIL) == MRTE_RESULT_OK) 
#define MRTE_FAILED(code)            (((code) &  MRTE_ERROR_FAIL) == MRTE_ERROR_FAIL)

typedef enum EResult
{
    //////////////////////////////////////////////////////////////////////////
    //                         success codes                                //         
    //////////////////////////////////////////////////////////////////////////
    MRTE_RESULT_OK =                    0x00000000,
        
    // general results - relevant to all MRTE modules
    MRTE_RESULT_END_OF_DATA =           MRTE_RESULT_FIRST_VALUE(MRTE_RESULT_MODULE_GENERAL),
    MRTE_RESULT_TRUE,
    MRTE_RESULT_FALSE,
    MRTE_RESULT_NOT_IMPLEMENTED,
    
    // MPI specific success results
    MRTE_RESULT_PRV_INSTANTIATED =      MRTE_RESULT_FIRST_VALUE(MRTE_RESULT_MODULE_MPI), 
    MRTE_RESULT_NO_EXTERNAL_CONTROL,
    
    // CPI specific success results
    MRTE_RESULT_NEW_ALLOCATION =        MRTE_RESULT_FIRST_VALUE(MRTE_RESULT_MODULE_CPI),

    // JIE specific success results
    MRTE_RESULT_ADDED_INSTRUCTION =     MRTE_RESULT_FIRST_VALUE(MRTE_RESULT_MODULE_JIE),
    MRTE_RESULT_NO_OPERAND,

    // CIE specific success results

    // RTUtil specific results
    MRTE_RESULT_ITERATION_STOPPED =     MRTE_RESULT_FIRST_VALUE(MRTE_RESULT_MODULE_RTUTIL),
    MRTE_RESULT_KEY_ALREADY_EXISTS,
    
    // class parser specific results
    MRTE_RESULT_NO_MORE_METHODS =		MRTE_RESULT_FIRST_VALUE(MRTE_RESULT_MODULE_CLASS_PARSER),
    
    // Heap specific results
    MRTE_RESULT_HEAP_PLACE_HOLDER =		MRTE_RESULT_FIRST_VALUE(MRTE_RESULT_MODULE_HEAP),

    // OSA specific results
    MRTE_RESULT_OSA_PLACE_HOLDER =		MRTE_RESULT_FIRST_VALUE(MRTE_RESULT_MODULE_OSA),
    
    
    
    //////////////////////////////////////////////////////////////////////////
    //                          error codes                                 //         
    //////////////////////////////////////////////////////////////////////////
    
    MRTE_ERROR_FAIL =                   0x80000000,
    
    // general errors - relevant to all MRTE modules
    MRTE_ERROR_ILLEGAL_ARGUMENT =       MRTE_ERROR_FIRST_VALUE(MRTE_RESULT_MODULE_GENERAL),
    MRTE_ERROR_NOT_SUPPORTED,
    MRTE_ERROR_OUT_OF_MEMORY,
    MRTE_ERROR_NULL_PTR,
    MRTE_ERROR_BUFFER_TOO_SHORT,
    MRTE_ERROR_FILE_NOT_FOUND,
    MRTE_ERROR_UNEXPECTED,
    MRTE_ERROR_LIBRARY_FAILURE,
    MRTE_ERROR_NOT_IMPLEMENTED,
    MRTE_ERROR_ILLEGAL_OPERATION,
    MRTE_ERROR_MODULE_NOT_INITIALIZED,
    MRTE_ERROR_READ_ONLY,
    
    // MPI specific errors
    MRTE_ERROR_ILLEGAL_ID =             MRTE_ERROR_FIRST_VALUE(MRTE_RESULT_MODULE_MPI),
    MRTE_ERROR_EVENT_NOT_REGISTERED,                // event is not registered
    MRTE_ERROR_CLIENT_NOT_REGISTERED,               // client not registered
    MRTE_ERROR_CONFLICT,                            // conflict error
    MRTE_ERROR_METHOD_ID_NOT_FOUND,
    MRTE_ERROR_PHASE_FAILURE, 
    MRTE_ERROR_PARTIAL_INFO,                        // not all requested data items were
                                                    // retrieved
    MRTE_ERROR_MONITOR_INTERRUPT,                   // a wait operation on a monitor object 
                                                    // timed out
    
    // CPI specific errors
    MRTE_ERROR_INTERFACE_FAILURE =      MRTE_ERROR_FIRST_VALUE(MRTE_RESULT_MODULE_CPI),
    
    // JIE specific errors
    MRTE_ERROR_INSTRUMENTATION_NOT_NEEDED = MRTE_ERROR_FIRST_VALUE(MRTE_RESULT_MODULE_JIE),
    MRTE_ERROR_UNABLE_TO_INSTRUMENT,
    MRTE_ERROR_ILLEGAL_TRY_BLOCK,
    MRTE_ERROR_OPERAND_MISMATCH,

    // CIE specific results
    MRTE_ERROR_NO_MORE_METHODS =        MRTE_ERROR_FIRST_VALUE(MRTE_RESULT_MODULE_CIE),
    MRTE_ERROR_NO_MORE_CLASSES,
	MRTE_ERROR_NO_MORE_TYPESPECS,
	MRTE_ERROR_ADD_BEFORE_FIRST,
	MRTE_ERROR_ADD_AFTER_LAST,
	MRTE_ERROR_MODULE_NOT_LOADED,
	MRTE_ERROR_MODULE_LOADED,
    
    
    // RTUtil specific errors
    MRTE_ERROR_NOT_YET_INITIALIZED =    MRTE_ERROR_FIRST_VALUE(MRTE_RESULT_MODULE_RTUTIL),
    MRTE_ERROR_IN_ITERATOR, 
    MRTE_ERROR_ALREADY_INITIALIZED,
    
    // class parser specific results
    MRTE_ERROR_ILL_CLASS_FILE =         MRTE_ERROR_FIRST_VALUE(MRTE_RESULT_MODULE_CLASS_PARSER),			
    
    // heap profiler specific errors
    MRTE_ERROR_CLASS_NOT_FOUND =        MRTE_ERROR_FIRST_VALUE(MRTE_RESULT_MODULE_HEAP),
    MRTE_ERROR_CLASS_INFO_ERROR,        
    MRTE_ERROR_HPR_SEND,                
    MRTE_ERROR_ALREADY_CREATED,         
    MRTE_ERROR_PIPE_ERROR,              
    MRTE_ERROR_CONNECTION_ERROR,        
    MRTE_ERROR_READ_ERROR,              
    MRTE_ERROR_WRITE_ERROR,             
    MRTE_ERROR_NO_MORE_GC_DATA,         
    MRTE_ERROR_NO_MORE_GC_CLASS_DATA,   
    MRTE_ERROR_DB_ERROR,                
    MRTE_ERROR_NO_MORE_AGE_DATA,        
    MRTE_ERROR_NO_MORE_AGE_CLASS_DATA,  
    MRTE_ERROR_UNEXPECTED_HEADER,       
    MRTE_ERROR_NO_MORE_TREE_DATA,

    // OSA specific results
    MRTE_ERROR_OSA_FAILURE =         MRTE_ERROR_FIRST_VALUE(MRTE_RESULT_MODULE_OSA),	
    MRTE_ERROR_INVALID_HANDLE,
    MRTE_ERROR_MEMORY_MAP_FAIL,
    MRTE_ERROR_FILE_FAILURE
    

} TResult;

#endif




