/*****************************************************************************
 * Copyright (c) 1997, 2010 Intel Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *
 * $Id$
 *****************************************************************************/

#ifndef MRTE_TYPES_H
#define MRTE_TYPES_H

#ifdef LIN
#include <wchar.h>
#endif

typedef   signed char       S8;
typedef unsigned char       U8;

typedef   signed short      S16;
typedef unsigned short      U16;

typedef   signed int        S32;
typedef unsigned int        U32;

#if defined(linux) || defined(_SOLARIS) || defined(_AIX) || defined(_SOLARISX86)
typedef   signed long long  S64;
typedef unsigned long long  U64;
#else
typedef   signed __int64    S64;
typedef unsigned __int64    U64;
#endif // linux

#if defined(EM64T_ARCH) || defined(IPF_ARCH) || (defined(__linux__) && defined(__s390x__)) || defined(_LP64) || (defined(MVS) && defined(_LP64))
typedef S64                 SIOP;
typedef U64                 UIOP;
#elif defined(IA32_ARCH) || (defined(__linux__) && defined(__s390__)) || defined(_ILP32) || defined(MVS)
typedef signed int          SIOP;
typedef unsigned int        UIOP;
#elif (defined(PPC_ARCH) && defined(_LP64))
typedef S64                 SIOP;
typedef U64                 UIOP;

#else
#   error "Architecture-specific configuration required (e.g IA32_ARCH, IPF_ARCH, AIX, EM64T_ARCH)"
#endif

typedef void * TMRTEHandle;
typedef S64 TMrteInt64;

#define MAX_MRTE_STRING_LENGTH	2048


//TODO: remove SMRTEString
struct SMRTEString
{
    char *       szBuffer;             // string buffer
    unsigned int uiLength;             // szBuffer size in bytes
    unsigned int uiRequiredSize;       // required size of szBuffer in bytes (including place for NULL termination)
};

typedef void* (*TMemoryAllocatorFunc)(unsigned int);

/**
 * Stores information about the heap instance data collected for the Object identified by TId.
 * Corresponds to ACCollector::MHeapObjectAnalysis. THeapObjectAnalysis contains the information 
 * collected about the Object.
 */
typedef struct {
	char * TId; // TPTP ID of the Heap Object
	void * resultValue; // Result returned by the Agent for the client
} THeapObjectAnalysis;

#endif


