/************************************************************************
 * Copyright (c) 2005, 2010 Intel Corporation and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: ACCollector.h,v 1.9 2010/12/15 16:49:36 mreid Exp $ 
 ************************************************************************/

#ifndef  _ACCOLLECTOR_H_
#define  _ACCOLLECTOR_H_

#include <map>
#include <string>

#include "log.h"
#include "ACC_Env.h"
#ifdef __MVS__
	#include "tptp/agents/BaseCollectorImpl.h"
#else
	#include "BaseCollectorImpl.h"
#endif
#include "BaseAgentImpl.h"
//#include "tptp/agents/BaseAgentImpl.h"

#define ACCOLLECTOR_AGENTLET_EXT               "org.eclipse.tptp.javaprofiler.agentlet"
#define ACCOLLECTOR_AGENTLET_HANDLER           "agentletHandleCommand"
#define ACCOLLECTOR_AGENTLET_HANDLER_SIGNATURE "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)Ljava/lang/String;"
namespace Martini { namespace ACCollector {

class ACCollector : public BaseCollectorImpl
{
    private:
        int m_dataListenerID;
        int m_AgentID;
        bool m_isWaiting;
        bool m_isTracing;
        bool m_isEnabledDataCollection;
        bool m_isFirstAfterStart;
        ACC_ENV* m_ACC_env;

        int receiveData(int sourceID, char buffer[], int bytesRead, DIME_HEADER_PTR_T dimeHeader);

        struct Agentlet {
	        
	        jclass      cls;
	        jmethodID   handler;
	        std::string iid;
	        std::string message;
	        
            Agentlet( const std::string& _iid, const std::string& _message, jclass _cls, jmethodID _handler )
            : cls(_cls), handler(_handler), iid(_iid), message(_message) { }
        };
        std::map<std::string,Agentlet*> m_agentlets;

        Agentlet* lookupAgentlet( JNIEnv* jni, const char* iid, const char* message );
        jobject buildParameterMap( JNIEnv* jni, tptp_list_t* paramList );
        const char* dispatchAgentlet( CmdBlock* cmdBlock );

    public:
        ACCollector();
        virtual ~ACCollector();

        static ACCollector& GetInstance();
        int Init(ACC_ENV* env, bool isControlled);

		#ifdef MVS
			CmdBlock* native2unicodeCmdBlock(CmdBlock* cmdBlock);
		#endif
        virtual int processCommand(CmdBlock* cmdBlock);

        // Collector interface commands.
        int run(CmdBlock* cmdBlock);
        int stop(CmdBlock* cmdBlock);
        int resume(CmdBlock* cmdBlock);
        int pause(CmdBlock* cmdBlock);
        int establishDataPath(int dataConnectionID, int dataChanneltype, int destinationID, int contextID);
        int releaseDataPath(int dataConnectionID);

        // ACCollector interface commands.
        
        int sendData_(char *s, unsigned short length)
        {
            return sendData(m_dataListenerID, s, length);
        };

        bool isAgentInitialized(int contextID);
        int SendVMAgentInitializedCommand();
        void SendWrongPhaseError(int contextID);

};

} /* namespace Martini */ } /* namespace ACCollector */

#endif // _ACCOLLECTOR_H_

