/************************************************************************
 * Copyright (c) 2006, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Intel Corporation - Initial API and implementation
 *    Viacheslav Rybalov, Intel - Initial API and implementation
 *
 * $Id: BaseProfiler.cpp,v 1.10 2008/06/05 22:04:51 jkubasta Exp $ 
 ************************************************************************/

#include "BaseProfiler.h"

using namespace Martini::BaseProf;
using namespace Martini::MPI;

Martini::OSA::IThreadSync* lockObject = Martini::OSA::CreateThreadSync();

CBaseProfiler::CBaseProfiler()
{
}

CBaseProfiler::~CBaseProfiler()
{
}

/*
 *    Init - Initializes internal data and registers for events
 */
TResult 
CBaseProfiler::Init(IMpi *pMpiApi, TId clientId, const char *szOptions) 
{
    LOG_TRACE(m_profilerName << " options: " << szOptions);

    TResult retVal;
    m_pProfEnv.m_pMpiApi = pMpiApi;
    m_pProfEnv.m_clientId = clientId;

    retVal = m_pProfEnv.Init("JPIAgent");
    if (MRTE_SUCCEEDED(retVal)) {
        LOG_TRACE("EC module (JPIAgent) loaded");
    } else {
        LOG_ERROR("EC module (JPIAgent) loading failed");
        return retVal;
    }

    retVal = ParceOptions(szOptions);
    if (MRTE_SUCCEEDED(retVal)) {
        LOG_TRACE(m_profilerName << ": Options parsed");
    } else {
        LOG_ERROR(m_profilerName << ": Options parsing failed");
        return retVal;
    }

    // register to events
    retVal = InitEvents();
    if (MRTE_SUCCEEDED(retVal)) {
        LOG_TRACE(m_profilerName << ": init success");
    } else {
        LOG_ERROR(m_profilerName << ": init failed");
        return retVal;
    }

    if (m_pProfEnv.ec_env->isCalcStackMap()) {
        pMpiApi->Configure(CF_JAVA_ENABLE_STACKMAP_CALC);
    }


    retVal = InitFilter();
    return retVal;
}

/*
 * InitEvents - initialize object event - register events
 */
TResult 
CBaseProfiler::InitEvents()
{
    TResult retVal;
    retVal = InitProfilerSpecificEvents();
    if (MRTE_FAILED(retVal)) {
        return retVal;
    }
    retVal = m_VMInitHandler.Init(&m_pProfEnv);        
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of VMInit event failed: " << retVal);
        return retVal;
    }
    retVal = m_VMShutdownHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of VMShutdown event failed: " << retVal);
        return retVal;
    }
    retVal = m_startHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of Start event failed: " << retVal);
        return retVal;
    }
    retVal = m_stopHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of Stop event failed: " << retVal);
        return retVal;
    }
    retVal = m_attachHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of Attach event failed: " << retVal);
        return retVal;
    }
    retVal = m_detachHandler.Init(&m_pProfEnv);
    if (MRTE_FAILED(retVal)) {
        LOG_ERROR("Initialization of Detach event failed: " << retVal);
        return retVal;
    }
    if (m_pProfEnv.ec_env->isEnabled()) {
        TResult res = m_pProfEnv.DisableSupportedEG();
        LOG_ASSERT(res == MRTE_RESULT_OK);
    }

    return retVal;
}
